/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.toolkit;

import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.impl.Parser;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.sonar.colorizer.KeywordsTokenizer;
import org.sonar.colorizer.Tokenizer;
import org.sonar.python.PythonConfiguration;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.parser.PythonParser;
import org.sonar.sslr.toolkit.AbstractConfigurationModel;
import org.sonar.sslr.toolkit.ConfigurationProperty;
import org.sonar.sslr.toolkit.Validators;

public class PythonConfigurationModel
extends AbstractConfigurationModel {
    private static final Logger LOG = Logger.getLogger(PythonConfigurationModel.class.getName());
    private static final String CHARSET_PROPERTY_KEY = "sonar.sourceEncoding";
    ConfigurationProperty charsetProperty = new ConfigurationProperty("Charset", "sonar.sourceEncoding", PythonConfigurationModel.getPropertyOrDefaultValue("sonar.sourceEncoding", "UTF-8"), Validators.charsetValidator());

    @Override
    public Charset getCharset() {
        return Charset.forName(this.charsetProperty.getValue());
    }

    @Override
    public List<ConfigurationProperty> getProperties() {
        return Collections.singletonList(this.charsetProperty);
    }

    @Override
    public Parser<Grammar> doGetParser() {
        return PythonParser.create(this.getConfiguration());
    }

    @Override
    public List<Tokenizer> doGetTokenizers() {
        return Arrays.asList(new KeywordsTokenizer("<span class=\"k\">", "</span>", PythonKeyword.keywordValues()));
    }

    PythonConfiguration getConfiguration() {
        return new PythonConfiguration(Charset.forName(this.charsetProperty.getValue()));
    }

    static String getPropertyOrDefaultValue(String propertyKey, String defaultValue) {
        String propertyValue = System.getProperty(propertyKey);
        if (propertyValue == null) {
            LOG.info(() -> "Property \"" + propertyKey + "\" is not set, using the default value \"" + defaultValue + "\".");
            return defaultValue;
        }
        LOG.info(() -> "Property \"" + propertyKey + "\" is set, using its value \"" + propertyValue + "\".");
        return propertyValue;
    }
}

