/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.toolkit;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.impl.ast.AstXmlPrinter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Objects;
import org.sonar.colorizer.HtmlOptions;
import org.sonar.colorizer.HtmlRenderer;
import org.sonar.sslr.toolkit.ConfigurationModel;

public class SourceCodeModel {
    private final ConfigurationModel configurationModel;
    private final HtmlRenderer htmlRenderer = new HtmlRenderer(new HtmlOptions(false, null, false));
    private String sourceCode;
    private AstNode astNode;

    public SourceCodeModel(ConfigurationModel configurationModel) {
        Objects.requireNonNull(configurationModel);
        this.configurationModel = configurationModel;
    }

    public void setSourceCode(File source, Charset charset) {
        this.astNode = this.configurationModel.getParser().parse(source);
        try {
            this.sourceCode = new String(Files.readAllBytes(Paths.get(source.getPath(), new String[0])), charset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setSourceCode(String sourceCode) {
        this.astNode = this.configurationModel.getParser().parse(sourceCode);
        this.sourceCode = sourceCode;
    }

    public String getHighlightedSourceCode() {
        return this.htmlRenderer.render(new StringReader(this.sourceCode), this.configurationModel.getTokenizers());
    }

    public String getXml() {
        return AstXmlPrinter.print(this.astNode);
    }

    public AstNode getAstNode() {
        return this.astNode;
    }
}

