/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import org.sonar.python.api.PythonTokenType;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.measures.MetricDef;

public class PythonLinesOfCodeVisitor<G extends Grammar>
extends SquidAstVisitor<G>
implements AstAndTokenVisitor {
    private final MetricDef metric;
    private int lastTokenLine;

    public PythonLinesOfCodeVisitor(MetricDef metric) {
        this.metric = metric;
    }

    public void visitFile(AstNode node) {
        this.lastTokenLine = -1;
    }

    public void visitToken(Token token) {
        if (!(token.getType().equals(GenericTokenType.EOF) || token.getType().equals((Object)PythonTokenType.DEDENT) || token.getType().equals((Object)PythonTokenType.INDENT) || token.getType().equals((Object)PythonTokenType.NEWLINE))) {
            String[] tokenLines = token.getValue().split("\n", -1);
            boolean firstLineAlreadyCounted = this.lastTokenLine == token.getLine();
            this.getContext().peekSourceCode().add(this.metric, (double)tokenLines.length - (double)firstLineAlreadyCounted);
            this.lastTokenLine = token.getLine() + tokenLines.length - 1;
        }
    }
}

