/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.python.TokenLocation;
import org.sonar.squidbridge.checks.SquidCheck;

public abstract class PythonCheck
extends SquidCheck<Grammar> {
    private List<PreciseIssue> issues = new ArrayList<PreciseIssue>();

    public List<PreciseIssue> getIssues() {
        return ImmutableList.copyOf(this.issues);
    }

    protected final PreciseIssue addIssue(AstNode node, String message) {
        PreciseIssue newIssue = new PreciseIssue(new IssueLocation(node, message), this.getContext().getFile());
        this.issues.add(newIssue);
        return newIssue;
    }

    protected final PreciseIssue addIssue(IssueLocation primaryLocation) {
        PreciseIssue newIssue = new PreciseIssue(primaryLocation, this.getContext().getFile());
        this.issues.add(newIssue);
        return newIssue;
    }

    protected final PreciseIssue addFileIssue(String message) {
        PreciseIssue newIssue = new PreciseIssue(new IssueLocation(message), this.getContext().getFile());
        this.issues.add(newIssue);
        return newIssue;
    }

    protected final PreciseIssue addIssue(Token token, String message) {
        return this.addIssue(new AstNode(token), message);
    }

    public static class IssueLocation {
        private Token firstToken;
        private TokenLocation lastTokenLocation;
        private String message;

        public IssueLocation(String message) {
            this.message = message;
            this.firstToken = null;
            this.lastTokenLocation = null;
        }

        public IssueLocation(AstNode node, String message) {
            this.message = message;
            this.firstToken = node.getToken();
            this.lastTokenLocation = new TokenLocation(node.getLastToken());
        }

        public IssueLocation(AstNode startNode, AstNode endNode, String message) {
            this.message = message;
            this.firstToken = startNode.getToken();
            this.lastTokenLocation = new TokenLocation(endNode.getLastToken());
        }

        public String message() {
            return this.message;
        }

        public int startLine() {
            return this.firstToken != null ? this.firstToken.getLine() : 0;
        }

        public int startLineOffset() {
            return this.firstToken != null ? this.firstToken.getColumn() : -1;
        }

        public int endLine() {
            return this.lastTokenLocation != null ? this.lastTokenLocation.endLine() : 0;
        }

        public int endLineOffset() {
            return this.lastTokenLocation != null ? this.lastTokenLocation.endLineOffset() : -1;
        }
    }

    public static class PreciseIssue {
        private final File file;
        private final IssueLocation primaryLocation;
        private Integer cost;
        private final List<IssueLocation> secondaryLocations;

        private PreciseIssue(IssueLocation primaryLocation, File file) {
            this.primaryLocation = primaryLocation;
            this.secondaryLocations = new ArrayList<IssueLocation>();
            this.file = file;
        }

        @Nullable
        public Integer cost() {
            return this.cost;
        }

        public PreciseIssue withCost(int cost) {
            this.cost = cost;
            return this;
        }

        public File file() {
            return this.file;
        }

        public IssueLocation primaryLocation() {
            return this.primaryLocation;
        }

        public PreciseIssue secondary(AstNode node, @Nullable String message) {
            this.secondaryLocations.add(new IssueLocation(node, message));
            return this;
        }

        public PreciseIssue secondary(IssueLocation issueLocation) {
            this.secondaryLocations.add(issueLocation);
            return this;
        }

        public List<IssueLocation> secondaryLocations() {
            return this.secondaryLocations;
        }
    }
}

