/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.SQLQuery;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.impl.SqlMetaType;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.impl.SqlUtils;

class SqlMappingItem {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<String> javaNames = new ArrayList<String>();
    private String dbName;
    private SqlType sqlType = new SqlType();

    SqlMappingItem(String dbName) {
        this.dbName = dbName;
    }

    void addName(String name) {
        this.javaNames.add(name);
    }

    void setMetaType(String sMetaType) {
        this.sqlType = new SqlType(sMetaType, this.sqlType);
    }

    void setHibernateType(String sHibernateType) {
        this.sqlType = new SqlType(sHibernateType);
    }

    public void setQueryResultMapping(Class<?> resultClass, SQLQuery query) {
        Type hibernateType = null;
        if (this.sqlType.getMetaType() != SqlMetaType.UNKNOWN) {
            hibernateType = this.sqlType.getHibernateType();
        } else {
            int count = this.javaNames.size();
            boolean exit = false;
            Class<?> objClass = resultClass;
            for (int i = 0; i < count - 1 && !exit; ++i) {
                String name = this.javaNames.get(i);
                Method m = SqlUtils.getMethod(objClass, SqlUtils.get(name), SqlUtils.is(name));
                if (m != null) {
                    objClass = m.getReturnType();
                    continue;
                }
                exit = true;
            }
            if (!exit) {
                String name = count > 0 ? this.javaNames.get(count - 1) : this.dbName;
                hibernateType = this.sqlType.getHibernateType(objClass, name);
            }
        }
        if (hibernateType != null) {
            query.addScalar(this.dbName, hibernateType);
        } else {
            query.addScalar(this.dbName);
        }
    }

    void setQueryResultData(Object resultInstance, Object resultValue) {
        if (resultValue == null) {
            return;
        }
        int count = this.javaNames.size();
        boolean exit = false;
        Object obj = resultInstance;
        for (int i = 0; i < count - 1 && !exit; ++i) {
            String name = this.javaNames.get(i);
            Method m = SqlUtils.getMethod(obj.getClass(), SqlUtils.get(name), SqlUtils.is(name));
            if (m != null) {
                Object nextObj = SqlUtils.invokeMethod(m, obj);
                if (nextObj == null) {
                    nextObj = SqlUtils.getInstance(m.getReturnType());
                    if (nextObj != null) {
                        m = SqlUtils.getMethod(obj.getClass(), SqlUtils.set(name), nextObj.getClass());
                        SqlUtils.invokeMethod(m, obj, nextObj);
                    } else {
                        exit = true;
                    }
                }
                obj = nextObj;
                continue;
            }
            exit = true;
        }
        if (!exit) {
            String name = count > 0 ? this.javaNames.get(count - 1) : this.dbName;
            this.sqlType.setResult(obj, name, resultValue);
        }
    }
}

