/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlOrder;
import org.sqlproc.engine.impl.SqlMetaElement;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlStatementLexer;
import org.sqlproc.engine.impl.SqlStatementParser;

public class SqlMetaStatement
implements SqlMetaElement {
    protected static Logger logger = LoggerFactory.getLogger(SqlMetaElement.class);
    List<SqlMetaElement> elements = new ArrayList<SqlMetaElement>();
    boolean hasOutputMapping;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlMetaStatement getInstance(String statement) throws SqlEngineException {
        SqlMetaStatement sqlMetaStatement;
        if (logger.isDebugEnabled()) {
            logger.debug(">> getInstance, statement=" + statement);
        }
        SqlMetaStatement stmt = null;
        try {
            StringBuilder s = new StringBuilder(statement);
            SqlStatementLexer lexer = new SqlStatementLexer((CharStream)new ANTLRStringStream(s.toString()));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SqlStatementParser parser = new SqlStatementParser((TokenStream)tokens);
            try {
                stmt = parser.parse();
            }
            catch (RecognitionException ex) {
                ex.printStackTrace();
            }
            if (!lexer.getErrors().isEmpty() || !parser.getErrors().isEmpty()) {
                throw new SqlEngineException("Statement error for '" + statement + "'", lexer.getErrors(), parser.getErrors());
            }
            sqlMetaStatement = stmt;
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("<< getInstance, stmt=" + stmt);
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<< getInstance, stmt=" + stmt);
        }
        return sqlMetaStatement;
    }

    SqlMetaStatement() {
    }

    void addElement(SqlMetaElement element) {
        this.elements.add(element);
    }

    public boolean isHasOutputMapping() {
        return this.hasOutputMapping;
    }

    public void setHasOutputMapping(boolean hasOutputMapping) {
        this.hasOutputMapping = hasOutputMapping;
    }

    public SqlProcessResult process(Type sqlStatementType, Object dynamicInputValues, Object staticInputValues, List<SqlOrder> order, Map<String, Object> features) {
        SqlProcessContext ctx = new SqlProcessContext(sqlStatementType, dynamicInputValues, staticInputValues, order, features);
        return this.process(ctx);
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        SqlProcessResult result = new SqlProcessResult(ctx);
        StringBuilder s = new StringBuilder();
        result.setSql(s);
        ArrayList<SqlProcessResult> orderByResult = new ArrayList<SqlProcessResult>();
        for (SqlMetaElement item : this.elements) {
            SqlProcessResult itemResult = item.process(ctx);
            if (itemResult.isAdd()) {
                if (itemResult.getOrderIndex() != null) {
                    orderByResult.add(itemResult);
                    continue;
                }
                s.append((CharSequence)itemResult.getSql());
                result.addInputValues(itemResult.getInputValues());
                result.addOutputValues(itemResult.getOutputValues());
                result.addIdentities(itemResult.getIdentities());
                continue;
            }
            result.addFalse();
        }
        if (!orderByResult.isEmpty()) {
            Collections.sort(orderByResult);
            s.append("order by ");
            boolean first = true;
            for (SqlProcessResult itemResult : orderByResult) {
                if (!first) {
                    s.append(", ");
                } else {
                    first = false;
                }
                s.append((CharSequence)itemResult.getSql());
                result.addInputValues(itemResult.getInputValues());
            }
        }
        return result;
    }

    public static enum Type {
        QUERY,
        CREATE,
        RETRIEVE,
        UPDATE,
        DELETE;

    }
}

