/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.type.SqlGenericType;
import org.sqlproc.engine.impl.type.SqlHibernateType;
import org.sqlproc.engine.impl.type.SqlMetaType;

class SqlType {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlMetaType metaType;
    private Type hibernateType;
    private String value;
    static Map<String, Field> hibernateTypes;
    static Map<Class<?>, Type> hibernateTypes2;

    SqlType() {
        this.metaType = SqlMetaType.DEFAULT;
        this.hibernateType = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SqlType(String sMetaType) {
        if (!sMetaType.startsWith("h_")) throw new SqlRuntimeException("Unsupported Meta Type " + sMetaType);
        String sHibernateType = sMetaType.substring(2).toUpperCase();
        Field f = hibernateTypes.get(sHibernateType);
        if (f == null) throw new SqlRuntimeException("Unsupported Hibernate Type " + sHibernateType);
        try {
            this.hibernateType = (Type)f.get(null);
            return;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    SqlType(SqlMetaType metaType) {
        this.metaType = metaType;
    }

    Type getHibernateType() {
        if (this.hibernateType != null) {
            return this.hibernateType;
        }
        if (this.metaType instanceof SqlGenericType) {
            return ((SqlGenericType)this.metaType).getHibernateType();
        }
        return null;
    }

    Type getHibernateType(Class<?> pojoClass, String attributeName) {
        Class<?> attributeType = BeanUtils.getFieldType(pojoClass, attributeName);
        return hibernateTypes2.get(attributeType);
    }

    SqlMetaType getMetaType() {
        return this.metaType;
    }

    void setResult(Object resultInstance, String attributeName, Object resultValue) throws SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("setResult " + this.metaType + " " + attributeName + " " + resultValue);
        }
        if (this.hibernateType != null) {
            SqlHibernateType.setResult(resultInstance, attributeName, resultValue, this.getHibernateType(), SqlProcessContext.isFeature("IGNORE_INPROPER_OUT"));
        } else {
            this.metaType.setResult(resultInstance, attributeName, resultValue, SqlProcessContext.isFeature("IGNORE_INPROPER_OUT"));
        }
    }

    void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType) throws SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("setParameter " + this.metaType + " " + paramName + " " + inputValue);
        }
        if (this.hibernateType != null) {
            SqlHibernateType.setParameter(query, paramName, inputValue, inputType, this.getHibernateType(), SqlProcessContext.isFeature("IGNORE_INPROPER_IN"));
        } else {
            this.metaType.setParameter(query, paramName, inputValue, inputType, SqlProcessContext.isFeature("IGNORE_INPROPER_IN"));
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Type{");
        sb.append(this.metaType).append(",h=").append(this.hibernateType).append(",v=").append(this.value).append("}");
        return sb.toString();
    }

    static {
        Field[] fields;
        hibernateTypes = new HashMap<String, Field>();
        for (Field f : fields = Hibernate.class.getFields()) {
            if (!Modifier.isStatic(f.getModifiers())) continue;
            try {
                if (!(f.get(null) instanceof Type)) continue;
                hibernateTypes.put(f.getName().toUpperCase(), f);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        hibernateTypes2 = new HashMap();
        hibernateTypes2.put(Integer.TYPE, (Type)Hibernate.INTEGER);
        hibernateTypes2.put(Integer.class, (Type)Hibernate.INTEGER);
        hibernateTypes2.put(Long.TYPE, (Type)Hibernate.LONG);
        hibernateTypes2.put(Long.class, (Type)Hibernate.LONG);
        hibernateTypes2.put(Short.TYPE, (Type)Hibernate.SHORT);
        hibernateTypes2.put(Short.class, (Type)Hibernate.SHORT);
        hibernateTypes2.put(Float.TYPE, (Type)Hibernate.FLOAT);
        hibernateTypes2.put(Float.class, (Type)Hibernate.FLOAT);
        hibernateTypes2.put(Double.TYPE, (Type)Hibernate.DOUBLE);
        hibernateTypes2.put(Double.class, (Type)Hibernate.DOUBLE);
        hibernateTypes2.put(Character.TYPE, (Type)Hibernate.CHARACTER);
        hibernateTypes2.put(Character.class, (Type)Hibernate.CHARACTER);
        hibernateTypes2.put(String.class, (Type)Hibernate.STRING);
        hibernateTypes2.put(Date.class, (Type)Hibernate.TIMESTAMP);
        hibernateTypes2.put(Boolean.TYPE, (Type)Hibernate.BOOLEAN);
        hibernateTypes2.put(Boolean.class, (Type)Hibernate.BOOLEAN);
        hibernateTypes2.put(BigInteger.class, (Type)Hibernate.BIG_INTEGER);
        hibernateTypes2.put(BigDecimal.class, (Type)Hibernate.BIG_DECIMAL);
        hibernateTypes2.put(byte[].class, (Type)Hibernate.BINARY);
        hibernateTypes2.put(Byte[].class, (Type)Hibernate.WRAPPER_BINARY);
    }
}

