/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl.type;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Date;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.type.Type;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.type.SqlGenericType;

public class SqlDateTimeType
extends SqlGenericType {
    @Override
    public Type getHibernateType() {
        return Hibernate.TIMESTAMP;
    }

    @Override
    public Class<?>[] getClassTypes() {
        return new Class[]{Date.class};
    }

    @Override
    public String[] getMetaTypes() {
        return new String[]{"DATETIME"};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setResult(Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        Method m;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setResult " + this.getMetaTypes()[0] + ": resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue);
        }
        if ((m = BeanUtils.getSetter(resultInstance, attributeName, Date.class)) != null) {
            if (resultValue instanceof Timestamp) {
                ((Timestamp)resultValue).setNanos(0);
                BeanUtils.simpleInvokeMethod(m, resultInstance, resultValue);
                return;
            } else if (resultValue instanceof Date) {
                BeanUtils.simpleInvokeMethod(m, resultInstance, resultValue);
                return;
            } else {
                if (!ingoreError) throw new SqlRuntimeException("Incorrect datetime " + resultValue + " for " + attributeName + " in " + resultInstance);
                this.logger.error("Incorrect datetime " + resultValue + " for " + attributeName + " in " + resultInstance);
            }
            return;
        } else {
            m = BeanUtils.getSetter(resultInstance, attributeName, LocalDateTime.class);
            if (m != null) {
                LocalDateTime dt = new LocalDateTime(resultValue);
                BeanUtils.simpleInvokeMethod(m, resultInstance, dt);
                return;
            } else {
                if (!ingoreError) throw new SqlRuntimeException("There's no setter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
                this.logger.error("There's no getter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
            }
        }
    }

    @Override
    public void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setParameter " + this.getMetaTypes()[0] + ": paramName=" + paramName + ", inputValue=" + inputValue + ", inputType=" + inputType);
        }
        if (inputValue == null) {
            query.setParameter(paramName, inputValue, (Type)Hibernate.TIMESTAMP);
        } else {
            DateTime dt = new DateTime(inputValue).withMillisOfSecond(0);
            query.setTimestamp(paramName, dt.toDate());
        }
    }
}

