/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlCrudEngine;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlEngineFactory;
import org.sqlproc.engine.SqlFeature;
import org.sqlproc.engine.SqlMonitor;
import org.sqlproc.engine.SqlMonitorFactory;
import org.sqlproc.engine.SqlQueryEngine;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.type.SqlComposedTypeFactory;
import org.sqlproc.engine.type.SqlInternalType;
import org.sqlproc.engine.type.SqlTypeFactory;

public class SqlEngineLoader
implements SqlEngineFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SET_PREFIX = "SET_";
    private static final int lSET_PREFIX = "SET_".length();
    private static final String FIELDS_REFERENCE = "#";
    private static final int lFIELDS_REFERENCE = "#".length();
    private static final String QUERY_PREFIX = "QRY_";
    private static final int lQUERY_PREFIX = "QRY_".length();
    private static final String INPUT_MAPPING_PREFIX = "IN_";
    private static final int lINPUT_MAPPING_PREFIX = "IN_".length();
    private static final String OUTPUT_MAPPING_PREFIX = "OUT_";
    private static final int lOUTPUT_MAPPING_PREFIX = "OUT_".length();
    private static final String CRUD_PREFIX = "CRUD_";
    private static final int lCRUD_PREFIX = "CRUD_".length();
    private SqlTypeFactory composedTypeFactory;
    private Map<String, SqlEngine> engines = new HashMap<String, SqlEngine>();
    private Map<String, String> sqls = new HashMap<String, String>();
    private Map<String, String> cruds = new HashMap<String, String>();
    private Map<String, String> fields = new HashMap<String, String>();
    private Map<String, Object> features = new HashMap<String, Object>();

    public SqlEngineLoader(Properties props, SqlTypeFactory typeFactory) throws SqlEngineException {
        this(props, typeFactory, (String)null, (SqlMonitorFactory)null, (List<SqlInternalType>)null, (String[])null);
    }

    public SqlEngineLoader(Properties props, SqlTypeFactory typeFactory, String filter) throws SqlEngineException {
        this(props, typeFactory, filter, (SqlMonitorFactory)null, (List<SqlInternalType>)null, (String[])null);
    }

    public SqlEngineLoader(Properties props, SqlTypeFactory typeFactory, String filter, SqlMonitorFactory monitorFactory) throws SqlEngineException {
        this(props, typeFactory, filter, monitorFactory, (List<SqlInternalType>)null, (String[])null);
    }

    public SqlEngineLoader(Properties props, SqlTypeFactory typeFactory, String filter, SqlMonitorFactory monitorFactory, String ... selectQueries) {
        this(props, typeFactory, filter, monitorFactory, (List<SqlInternalType>)null, selectQueries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlEngineLoader(Properties props, SqlTypeFactory typeFactory, String filter, SqlMonitorFactory monitorFactory, List<SqlInternalType> customTypes, String ... selectQueries) throws SqlEngineException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">> SqlEngineLoader, props=" + props + ", typeFactory=" + typeFactory + ", monitorFactory=" + monitorFactory + ", filter=" + filter + ", customTypes=" + customTypes + ", selectQueries=" + selectQueries);
        }
        if (props == null) {
            throw new SqlEngineException("Missing SQL META queries");
        }
        if (typeFactory == null) {
            throw new SqlEngineException("Missing META types factory");
        }
        this.composedTypeFactory = new SqlComposedTypeFactory(typeFactory, customTypes);
        try {
            SqlMetaStatement stmt;
            String filterPrefix;
            HashSet<String> setSelectQueries = selectQueries != null && selectQueries.length > 0 ? new HashSet<String>(Arrays.asList(selectQueries)) : null;
            String string = filterPrefix = filter != null ? filter.toUpperCase() : null;
            if (filterPrefix != null && !filterPrefix.endsWith("_")) {
                filterPrefix = filterPrefix + "_";
            }
            if (filterPrefix != null && (filterPrefix.equals(QUERY_PREFIX) || filterPrefix.equals(CRUD_PREFIX) || filterPrefix.equals(OUTPUT_MAPPING_PREFIX) || filterPrefix.equals(INPUT_MAPPING_PREFIX) || filterPrefix.equals(SET_PREFIX))) {
                filterPrefix = null;
            }
            int filterPrefixLength = filterPrefix != null ? filterPrefix.length() : 0;
            String fullPrefix = filterPrefix != null ? filterPrefix + "DEFAULT_" : null;
            int fullPrefixLength = fullPrefix != null ? fullPrefix.length() : 0;
            String shortPrefix = "DEFAULT_";
            int shortPrefixLength = shortPrefix.length();
            for (Field f : SqlFeature.class.getDeclaredFields()) {
                String featureName;
                if (fullPrefix != null && f.getName().startsWith(fullPrefix) && this.features.get(featureName = f.getName().substring(fullPrefixLength)) == null) {
                    try {
                        this.features.put(featureName, f.get(null));
                    }
                    catch (IllegalArgumentException e) {
                    }
                    catch (IllegalAccessException e) {
                        // empty catch block
                    }
                }
                if (!f.getName().startsWith(shortPrefix) || this.features.get(featureName = f.getName().substring(shortPrefixLength)) != null) continue;
                try {
                    this.features.put(featureName, f.get(null));
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
            StringBuilder errors = new StringBuilder();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = ((String)entry.getKey()).toUpperCase();
                String value = (String)entry.getValue();
                String name = null;
                if (filterPrefix != null && key.startsWith(filterPrefix)) {
                    key = key.substring(filterPrefixLength);
                }
                if (key.startsWith(QUERY_PREFIX)) {
                    name = key.substring(lQUERY_PREFIX);
                    if (setSelectQueries != null && !setSelectQueries.contains(name)) continue;
                    if (this.sqls.containsKey(name)) {
                        errors.append("Duplicate QRY: ").append(key).append("\n");
                        continue;
                    }
                    this.sqls.put(name, value);
                    continue;
                }
                if (key.startsWith(CRUD_PREFIX)) {
                    name = key.substring(lCRUD_PREFIX);
                    if (setSelectQueries != null && !setSelectQueries.contains(name)) continue;
                    if (this.cruds.containsKey(name)) {
                        errors.append("Duplicate CRUD: ").append(key).append("\n");
                        continue;
                    }
                    this.cruds.put(name, value);
                    continue;
                }
                if (key.startsWith(OUTPUT_MAPPING_PREFIX)) {
                    name = key.substring(lOUTPUT_MAPPING_PREFIX);
                    if (setSelectQueries != null && !setSelectQueries.contains(name)) continue;
                    if (this.fields.containsKey(name)) {
                        errors.append("Duplicate OUT: ").append(key).append("\n");
                        continue;
                    }
                    this.fields.put(name, value);
                    continue;
                }
                if (!key.startsWith(SET_PREFIX)) continue;
                name = key.substring(lSET_PREFIX);
                if ("true".equalsIgnoreCase(value)) {
                    this.features.put(name, Boolean.TRUE);
                    continue;
                }
                if ("false".equalsIgnoreCase(value)) {
                    this.features.put(name, Boolean.FALSE);
                    continue;
                }
                this.features.put(name, value);
            }
            for (String name : this.fields.keySet()) {
                if (this.sqls.containsKey(name)) continue;
                errors.append("For the OUT/FIELDS there's no QRY: ").append(name).append("\n");
            }
            if (errors.length() > 0) {
                throw new SqlEngineException(errors.toString());
            }
            for (String name : this.sqls.keySet()) {
                SqlMonitor monitor;
                stmt = null;
                try {
                    stmt = SqlMetaStatement.getInstance(this.sqls.get(name), this.composedTypeFactory);
                }
                catch (SqlEngineException see) {
                    errors.append(name + ":" + see.getMessage());
                    continue;
                }
                SqlMappingRule mapping = null;
                if (!stmt.isHasOutputMapping() && !this.fields.containsKey(name)) {
                    errors.append("For the QRY there's no OUT: ").append(name).append("\n");
                } else if (this.fields.containsKey(name)) {
                    try {
                        String sMapping = this.fields.get(name).trim();
                        if (sMapping.startsWith(FIELDS_REFERENCE)) {
                            String sRealMapping = props.getProperty(sMapping.substring(lFIELDS_REFERENCE).trim());
                            if (sRealMapping == null) {
                                errors.append("For IN/OUT doesn't exist reference: ").append(name).append("->").append(sMapping).append("\n");
                            } else {
                                mapping = SqlMappingRule.getInstance(sRealMapping, this.composedTypeFactory);
                            }
                        } else {
                            mapping = !sMapping.isEmpty() ? SqlMappingRule.getInstance(sMapping, this.composedTypeFactory) : new SqlMappingRule();
                        }
                    }
                    catch (SqlEngineException see) {
                        errors.append(see.getMessage());
                    }
                }
                SqlMonitor sqlMonitor = monitor = monitorFactory != null ? monitorFactory.getSqlMonitor(name, this.features) : null;
                if (stmt == null) continue;
                this.engines.put(name, new SqlQueryEngine(name, stmt, mapping, monitor, this.features, this.composedTypeFactory));
            }
            for (String name : this.cruds.keySet()) {
                SqlMonitor monitor;
                stmt = null;
                try {
                    stmt = SqlMetaStatement.getInstance(this.cruds.get(name), this.composedTypeFactory);
                }
                catch (SqlEngineException see) {
                    errors.append(see.getMessage());
                    continue;
                }
                SqlMonitor sqlMonitor = monitor = monitorFactory != null ? monitorFactory.getSqlMonitor(name, this.features) : null;
                if (stmt == null) continue;
                this.engines.put(name, new SqlCrudEngine(name, stmt, monitor, this.features, this.composedTypeFactory));
            }
            if (errors.length() > 0) {
                throw new SqlEngineException(errors.toString());
            }
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< SqlEngineLoader, engines=" + this.engines + ", sqls=" + this.sqls + ", cruds=" + this.cruds + ", fields=" + this.fields + ", features=" + this.features);
            }
        }
    }

    public Collection<String> getNames() {
        return this.engines.keySet();
    }

    public String getMetaSql(String name) {
        return this.sqls.get(name);
    }

    public String getMappingRule(String name) {
        return this.fields.get(name);
    }

    @Override
    public SqlQueryEngine getQueryEngine(String name) {
        SqlEngine o = this.engines.get(name);
        if (o != null && o instanceof SqlQueryEngine) {
            return (SqlQueryEngine)o;
        }
        return null;
    }

    @Override
    public SqlCrudEngine getCrudEngine(String name) {
        SqlEngine o = this.engines.get(name);
        if (o != null && o instanceof SqlCrudEngine) {
            return (SqlCrudEngine)o;
        }
        return null;
    }
}

