/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.ArrayList;
import java.util.List;
import org.sqlproc.engine.impl.ErrorMsg;

public class SqlEngineException
extends RuntimeException {
    private List<ErrorMsg> errors = new ArrayList<ErrorMsg>();

    public SqlEngineException(String msg) {
        super(msg);
    }

    public SqlEngineException(String msg, List<ErrorMsg> lexerErrors, List<ErrorMsg> parserErrors, List<ErrorMsg> processorErrors) {
        super(msg);
        if (lexerErrors != null && !lexerErrors.isEmpty()) {
            this.errors.addAll(lexerErrors);
        }
        if (parserErrors != null && !parserErrors.isEmpty()) {
            this.errors.addAll(parserErrors);
        }
        if (processorErrors != null && !processorErrors.isEmpty()) {
            this.errors.addAll(processorErrors);
        }
    }

    public SqlEngineException(String msg, List<ErrorMsg> lexerErrors, List<ErrorMsg> parserErrors) {
        this(msg, lexerErrors, parserErrors, null);
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(super.getMessage());
        if (!this.errors.isEmpty()) {
            sb.append("\nANTLR messages:");
        }
        for (ErrorMsg errorMsg : this.errors) {
            sb.append("\n  ").append(errorMsg.toString());
        }
        return sb.toString();
    }
}

