/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.jdbc.type.JdbcBigDecimalType;
import org.sqlproc.engine.jdbc.type.JdbcBigIntegerType;
import org.sqlproc.engine.jdbc.type.JdbcBlobType;
import org.sqlproc.engine.jdbc.type.JdbcBooleanType;
import org.sqlproc.engine.jdbc.type.JdbcByteArrayType;
import org.sqlproc.engine.jdbc.type.JdbcByteArrayWrapperType;
import org.sqlproc.engine.jdbc.type.JdbcByteType;
import org.sqlproc.engine.jdbc.type.JdbcCharType;
import org.sqlproc.engine.jdbc.type.JdbcClobType;
import org.sqlproc.engine.jdbc.type.JdbcDateTimeType;
import org.sqlproc.engine.jdbc.type.JdbcDateType;
import org.sqlproc.engine.jdbc.type.JdbcDefaultType;
import org.sqlproc.engine.jdbc.type.JdbcDoubleType;
import org.sqlproc.engine.jdbc.type.JdbcEnumIntegerType;
import org.sqlproc.engine.jdbc.type.JdbcEnumStringType;
import org.sqlproc.engine.jdbc.type.JdbcFloatType;
import org.sqlproc.engine.jdbc.type.JdbcFromDateType;
import org.sqlproc.engine.jdbc.type.JdbcIntegerType;
import org.sqlproc.engine.jdbc.type.JdbcLongType;
import org.sqlproc.engine.jdbc.type.JdbcOracleCursorType;
import org.sqlproc.engine.jdbc.type.JdbcShortType;
import org.sqlproc.engine.jdbc.type.JdbcStringType;
import org.sqlproc.engine.jdbc.type.JdbcTextType;
import org.sqlproc.engine.jdbc.type.JdbcTimeType;
import org.sqlproc.engine.jdbc.type.JdbcTimestampType;
import org.sqlproc.engine.jdbc.type.JdbcToDateType;
import org.sqlproc.engine.type.SqlIdentityType;
import org.sqlproc.engine.type.SqlInternalType;
import org.sqlproc.engine.type.SqlMetaType;
import org.sqlproc.engine.type.SqlTypeFactory;

public class JdbcTypeFactory
implements SqlTypeFactory {
    private static JdbcTypeFactory factory = new JdbcTypeFactory();
    static final SqlMetaType ENUM_INT = new JdbcEnumIntegerType();
    static final SqlMetaType ENUM_STRING = new JdbcEnumStringType();
    static final SqlMetaType BIG_DECIMAL = new JdbcBigDecimalType();
    static final SqlMetaType BIG_INTEGER = new JdbcBigIntegerType();
    static final SqlMetaType BOOLEAN = new JdbcBooleanType();
    static final SqlMetaType BYTE_ARRAY = new JdbcByteArrayType();
    static final SqlMetaType BYTE_ARRAY_WRAPPER = new JdbcByteArrayWrapperType();
    static final SqlMetaType BYTE = new JdbcByteType();
    static final SqlMetaType CHAR = new JdbcCharType();
    static final SqlMetaType DATE_TIME = new JdbcDateTimeType();
    static final SqlMetaType DATE = new JdbcDateType();
    static final SqlMetaType DOUBLE = new JdbcDoubleType();
    static final SqlMetaType FLOAT = new JdbcFloatType();
    static final SqlMetaType FROM_DATE = new JdbcFromDateType();
    static final SqlMetaType INTEGER = new JdbcIntegerType();
    static final SqlMetaType LONG = new JdbcLongType();
    static final SqlMetaType SHORT = new JdbcShortType();
    static final SqlMetaType TEXT = new JdbcTextType();
    static final SqlMetaType STRING = new JdbcStringType();
    static final SqlMetaType TIMESTAMP = new JdbcTimestampType();
    static final SqlMetaType TIME = new JdbcTimeType();
    static final SqlMetaType TO_DATE = new JdbcToDateType();
    static final SqlMetaType BLOB = new JdbcBlobType();
    static final SqlMetaType CLOB = new JdbcClobType();
    static final SqlMetaType ORACLE_CURSOR = new JdbcOracleCursorType();
    static final SqlMetaType IDENTITY = new SqlIdentityType(){

        @Override
        public Object getProviderSqlType() {
            return null;
        }

        @Override
        public Object getProviderSqlNullType() {
            return null;
        }
    };
    static final SqlMetaType DEFAULT = new JdbcDefaultType();
    static final SqlMetaType[] TYPES = new SqlMetaType[]{BIG_DECIMAL, BIG_INTEGER, BOOLEAN, BYTE_ARRAY, BYTE, CHAR, DATE_TIME, DATE, DOUBLE, ENUM_INT, ENUM_STRING, FLOAT, FROM_DATE, INTEGER, LONG, SHORT, STRING, TIMESTAMP, TIME, TO_DATE, TEXT, BLOB, CLOB, ORACLE_CURSOR};
    static Map<Class<?>, SqlMetaType> CLASS_TO_TYPE_MAP = new HashMap();
    static Map<String, SqlMetaType> META_TO_TYPE_MAP = new HashMap<String, SqlMetaType>();

    private JdbcTypeFactory() {
    }

    public static JdbcTypeFactory getInstance() {
        return factory;
    }

    @Override
    public SqlMetaType getDefaultType() {
        return DEFAULT;
    }

    @Override
    public SqlMetaType getEnumIntegerType() {
        return ENUM_INT;
    }

    @Override
    public SqlMetaType getEnumStringType() {
        return ENUM_STRING;
    }

    @Override
    public SqlMetaType getIdentityType() {
        return IDENTITY;
    }

    @Override
    public SqlMetaType[] getAllTypes() {
        return TYPES;
    }

    @Override
    public SqlMetaType getMetaType(Class<?> clazz) {
        return CLASS_TO_TYPE_MAP.get(clazz);
    }

    @Override
    public SqlMetaType getMetaType(String name) {
        if (name.startsWith("h_")) {
            throw new UnsupportedOperationException();
        }
        SqlMetaType metaType = META_TO_TYPE_MAP.get(name.toUpperCase());
        if (metaType == null) {
            throw new SqlRuntimeException("Unsupported Meta Type " + name);
        }
        return metaType;
    }

    static {
        for (SqlMetaType type : TYPES) {
            if (!(type instanceof SqlInternalType)) continue;
            for (Class<?> classType : ((SqlInternalType)type).getClassTypes()) {
                CLASS_TO_TYPE_MAP.put(classType, type);
            }
            for (String metaType : ((SqlInternalType)type).getMetaTypes()) {
                META_TO_TYPE_MAP.put(metaType.toUpperCase(), type);
            }
        }
        CLASS_TO_TYPE_MAP = Collections.unmodifiableMap(CLASS_TO_TYPE_MAP);
        META_TO_TYPE_MAP = Collections.unmodifiableMap(META_TO_TYPE_MAP);
    }
}

