/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlMonitor;
import org.sqlproc.engine.SqlProcessorException;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.SqlSession;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlMappingResult;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.type.SqlTypeFactory;

public class SqlProcedureEngine
extends SqlEngine {
    public SqlProcedureEngine(String name, String statement, String mapping, SqlTypeFactory typeFactory) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(name, statement, typeFactory), mapping != null ? SqlMappingRule.getInstance(name, mapping, typeFactory) : null, null, null, typeFactory);
    }

    public SqlProcedureEngine(String name, String statement, String mapping, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(name, statement, typeFactory), mapping != null ? SqlMappingRule.getInstance(name, mapping, typeFactory) : null, monitor, features, typeFactory);
    }

    public SqlProcedureEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlTypeFactory typeFactory) {
        super(name, statement, mapping, null, null, typeFactory);
    }

    public SqlProcedureEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory) {
        super(name, statement, mapping, monitor, features, typeFactory);
    }

    public <E> List<E> callQuery(SqlSession session, Class<E> resultClass, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.callQuery(session, resultClass, dynamicInputValues, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> List<E> callQuery(final SqlSession session, final Class<E> resultClass, final Object dynamicInputValues, final Object staticInputValues, final int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> callQuery, session=" + session + ", resultClass=" + resultClass + ", dynamicInputValues=" + dynamicInputValues + ", staticInputValues=" + staticInputValues + ", maxTimeout=" + maxTimeout);
        }
        List<E> result = null;
        try {
            List<E> list = result = this.monitor.runList(new SqlMonitor.Runner(){

                @Override
                public List<E> run() {
                    SqlProcessResult processResult = SqlProcedureEngine.this.statement.process(SqlMetaStatement.Type.CALL, dynamicInputValues, staticInputValues, null, SqlProcedureEngine.this.features, SqlProcedureEngine.this.typeFactory);
                    SqlQuery query = session.createSqlQuery(processResult.getSql().toString());
                    if (maxTimeout > 0) {
                        query.setTimeout(maxTimeout);
                    }
                    processResult.setQueryParams(session, query);
                    SqlMappingResult mappingResult = SqlMappingRule.merge(SqlProcedureEngine.this.mapping, processResult);
                    mappingResult.setQueryResultMapping(resultClass, null, query);
                    List list = query.callList();
                    ArrayList<Object> result = new ArrayList<Object>();
                    Object resultInstance = null;
                    Object[] resultValue = null;
                    HashMap<String, Object> instances = new HashMap<String, Object>();
                    for (Object resultRow : list) {
                        Object[] objectArray;
                        if (resultRow instanceof Object[]) {
                            objectArray = (Object[])resultRow;
                        } else {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = resultRow;
                        }
                        resultValue = objectArray;
                        resultInstance = BeanUtils.getInstance(resultClass);
                        if (resultInstance == null) {
                            throw new SqlRuntimeException("There's problem to instantiate " + resultClass);
                        }
                        mappingResult.setQueryResultData(resultInstance, resultValue, instances, null, null);
                        result.add(resultInstance);
                    }
                    return result;
                }
            }, resultClass);
            return list;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< callQuery, result=" + result);
            }
        }
    }

    public int callUpdate(SqlSession session, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.callUpdate(session, dynamicInputValues, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int callUpdate(final SqlSession session, final Object dynamicInputValues, final Object staticInputValues, final int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> callUpdate, session=" + session + ", dynamicInputValues=" + dynamicInputValues + ", staticInputValues=" + staticInputValues + ", maxTimeout=" + maxTimeout);
        }
        Integer count = null;
        try {
            count = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Integer run() {
                    SqlProcessResult processResult = SqlProcedureEngine.this.statement.process(SqlMetaStatement.Type.CALL, dynamicInputValues, staticInputValues, null, SqlProcedureEngine.this.features, SqlProcedureEngine.this.typeFactory);
                    SqlQuery query = session.createSqlQuery(processResult.getSql().toString());
                    if (maxTimeout > 0) {
                        query.setTimeout(maxTimeout);
                    }
                    processResult.setQueryParams(session, query);
                    Integer count = query.callUpdate();
                    processResult.postProcess();
                    return count;
                }
            }, Integer.class);
            int n = count;
            return n;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< callUpdate, result=" + count);
            }
        }
    }

    public Object callFunction(SqlSession session, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.callFunction(session, dynamicInputValues, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callFunction(final SqlSession session, final Object dynamicInputValues, final Object staticInputValues, final int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> callFunction, session=" + session + ", dynamicInputValues=" + dynamicInputValues + ", staticInputValues=" + staticInputValues + ", maxTimeout=" + maxTimeout);
        }
        Object result = null;
        try {
            Object object = result = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Object run() {
                    SqlProcessResult processResult = SqlProcedureEngine.this.statement.process(SqlMetaStatement.Type.CALL, dynamicInputValues, staticInputValues, null, SqlProcedureEngine.this.features, SqlProcedureEngine.this.typeFactory);
                    SqlQuery query = session.createSqlQuery(processResult.getSql().toString());
                    if (maxTimeout > 0) {
                        query.setTimeout(maxTimeout);
                    }
                    processResult.setQueryParams(session, query);
                    if (SqlProcedureEngine.this.mapping != null) {
                        SqlMappingResult mappingResult = SqlMappingRule.merge(SqlProcedureEngine.this.mapping, processResult);
                        mappingResult.setQueryResultMapping(Object.class, null, query);
                    }
                    Object result = query.callFunction();
                    processResult.postProcess();
                    return result;
                }
            }, Object.class);
            return object;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< callFunction, result=" + result);
            }
        }
    }

    public String getCallSql(Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.getSql(dynamicInputValues, staticInputValues, SqlMetaStatement.Type.CALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSql(final Object dynamicInputValues, final Object staticInputValues, final SqlMetaStatement.Type statementType) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> getSql, dynamicInputValues=" + dynamicInputValues + ", staticInputValues=" + staticInputValues);
        }
        String sql = null;
        try {
            String string = sql = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public String run() {
                    SqlProcessResult processResult = SqlProcedureEngine.this.statement.process(statementType, dynamicInputValues, staticInputValues, null, SqlProcedureEngine.this.features, SqlProcedureEngine.this.typeFactory);
                    return processResult.getSql().toString();
                }
            }, String.class);
            return string;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< getSql, sql=" + sql);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public SqlMonitor getMonitor() {
        return this.monitor;
    }
}

