/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.impl.SqlMetaElement;
import org.sqlproc.engine.impl.SqlMetaLogOperand;
import org.sqlproc.engine.impl.SqlMetaLogOperator;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;

class SqlMetaLogExpr
implements SqlMetaElement,
SqlMetaLogOperand {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean not;
    List<SqlMetaLogOperand> elements = new ArrayList<SqlMetaLogOperand>();

    SqlMetaLogExpr() {
        this.not = false;
    }

    SqlMetaLogExpr(boolean not) {
        this.not = not;
    }

    void addElement(SqlMetaLogOperand element) {
        this.elements.add(element);
    }

    boolean isNot() {
        return this.not;
    }

    void setNot(boolean not) {
        this.not = not;
    }

    @Override
    public boolean processExpression(SqlProcessContext ctx) {
        SqlMetaLogOperator operator = null;
        boolean result = this.elements != null && this.elements.size() > 0;
        int state = 0;
        for (SqlMetaLogOperand item : this.elements) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("LogDataExpression process " + item + " in state " + state);
            }
            switch (state) {
                case 0: {
                    boolean operand = item.processExpression(ctx);
                    if (operator == null) {
                        result = operand;
                    } else if (operator.getType() == SqlMetaLogOperator.Type.AND) {
                        result = result && operand;
                    } else if (operator.getType() == SqlMetaLogOperator.Type.OR) {
                        result = result || operand;
                    }
                    state = 1;
                    break;
                }
                case 1: {
                    operator = (SqlMetaLogOperator)item;
                    state = 0;
                }
            }
        }
        return this.not ? !result : result;
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        SqlProcessResult result = new SqlProcessResult(ctx);
        if (this.processExpression(ctx)) {
            result.addTrue();
        } else {
            result.addFalse();
        }
        return result;
    }
}

