/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sqlproc.engine.SqlControl;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlExtendedMonitor;
import org.sqlproc.engine.SqlMonitor;
import org.sqlproc.engine.SqlOrder;
import org.sqlproc.engine.SqlProcessorException;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRowProcessor;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.SqlSession;
import org.sqlproc.engine.annotation.Beta;
import org.sqlproc.engine.config.SqlEngineConfiguration;
import org.sqlproc.engine.impl.SqlMappingResult;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlStandardControl;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.plugin.SqlPluginFactory;
import org.sqlproc.engine.type.SqlTypeFactory;

public class SqlQueryEngine
extends SqlEngine {
    public static final SqlOrder NO_ORDER = SqlOrder.getOrder();
    public static final SqlOrder ASC_ORDER = SqlOrder.getAscOrder(1);
    public static final SqlOrder DESC_ORDER = SqlOrder.getDescOrder(1);

    public SqlQueryEngine(String name, String statement, String mapping, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(name, statement, typeFactory), mapping != null ? SqlMappingRule.getInstance(name, mapping, typeFactory) : null, null, null, typeFactory, pluginFactory, null);
    }

    public SqlQueryEngine(String name, String statement, String mapping, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(name, statement, typeFactory), mapping != null ? SqlMappingRule.getInstance(name, mapping, typeFactory) : null, monitor, features, typeFactory, pluginFactory, null);
    }

    public SqlQueryEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) {
        super(name, statement, mapping, null, null, typeFactory, pluginFactory, null);
    }

    public SqlQueryEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) {
        super(name, statement, mapping, monitor, features, typeFactory, pluginFactory, null);
    }

    public SqlQueryEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, SqlEngineConfiguration configuration) {
        super(name, statement, mapping, monitor, features, typeFactory, pluginFactory, configuration);
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass) throws SqlProcessorException, SqlRuntimeException {
        return this.query(session, resultClass, null, (SqlControl)null);
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.query(session, resultClass, dynamicInputValues, (SqlControl)null);
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, SqlOrder order) throws SqlProcessorException, SqlRuntimeException {
        return this.query(session, resultClass, dynamicInputValues, new SqlStandardControl().setOrder(order));
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.query(session, resultClass, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues));
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, Map<String, Class<?>> moreResultClasses) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.query(session, resultClass, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setMoreResultClasses(moreResultClasses));
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, SqlOrder order) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.query(session, resultClass, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setOrder(order));
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, SqlOrder order, Map<String, Class<?>> moreResultClasses) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.query(session, resultClass, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setOrder(order).setMoreResultClasses(moreResultClasses));
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Integer firstResult, Integer maxResults) throws SqlProcessorException, SqlRuntimeException {
        return this.query(session, resultClass, dynamicInputValues, new SqlStandardControl().setMaxResults(maxResults).setFirstResult(firstResult));
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, Integer firstResult, Integer maxResults) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.query(session, resultClass, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxResults(maxResults).setFirstResult(firstResult));
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, SqlOrder order, Integer maxTimeout, Integer maxResults, Integer firstResult) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.query(session, resultClass, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setOrder(order).setMaxTimeout(maxTimeout).setMaxResults(maxResults).setFirstResult(firstResult));
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, SqlOrder order, Integer maxTimeout, Integer maxResults, Integer firstResult, Map<String, Class<?>> moreResultClasses) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.query(session, resultClass, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setOrder(order).setMaxTimeout(maxTimeout).setMaxResults(maxResults).setFirstResult(firstResult).setMoreResultClasses(moreResultClasses));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> List<E> query(final SqlSession session, final Class<E> resultClass, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException {
        List<E> list;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> query, session=" + session + ", resultClass=" + resultClass + ", dynamicInputValues=" + dynamicInputValues + ", sqlControl=" + sqlControl);
        }
        this.checkDynamicInputValues(dynamicInputValues);
        final QueryExecutor executor = new QueryExecutor(new ArrayList());
        List<E> rows = null;
        try {
            list = rows = this.monitor.runList(new SqlMonitor.Runner(){

                @Override
                public List<E> run() {
                    final SqlRuntimeContext runtimeContext = executor.prepareQuery(session, resultClass, dynamicInputValues, sqlControl);
                    if (SqlQueryEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlQueryEngine.this.monitor;
                        return monitorExt.runListSql(new SqlMonitor.Runner(){

                            @Override
                            public List<E> run() {
                                return executor.execute(resultClass, sqlControl, runtimeContext);
                            }
                        }, resultClass);
                    }
                    return executor.execute(resultClass, sqlControl, runtimeContext);
                }
            }, resultClass);
        }
        catch (Throwable throwable) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< query, result rownums=" + (rows != null ? rows.size() : -1));
            }
            throw throwable;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("<< query, result rownums=" + (rows != null ? rows.size() : -1));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Beta
    public <E> Integer query(final SqlSession session, final Class<E> resultClass, final Object dynamicInputValues, final SqlControl sqlControl, final SqlRowProcessor<E> sqlRowProcessor) throws SqlProcessorException, SqlRuntimeException {
        Integer n;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> query, session=" + session + ", resultClass=" + resultClass + ", dynamicInputValues=" + dynamicInputValues + ", sqlControl=" + sqlControl);
        }
        this.checkDynamicInputValues(dynamicInputValues);
        final QueryExecutor executor = new QueryExecutor(0);
        Integer rownums = null;
        try {
            n = rownums = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Integer run() {
                    final SqlRuntimeContext runtimeContext = executor.prepareQuery(session, resultClass, dynamicInputValues, sqlControl);
                    if (SqlQueryEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlQueryEngine.this.monitor;
                        return monitorExt.runSql(new SqlMonitor.Runner(){

                            @Override
                            public Integer run() {
                                return executor.execute(resultClass, sqlControl, sqlRowProcessor, runtimeContext);
                            }
                        }, Integer.class);
                    }
                    return executor.execute(resultClass, sqlControl, sqlRowProcessor, runtimeContext);
                }
            }, Integer.class);
        }
        catch (Throwable throwable) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< query, result rownums=" + rownums);
            }
            throw throwable;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("<< query, result rownums=" + rownums);
        }
        return n;
    }

    public int queryCount(SqlSession session) throws SqlProcessorException, SqlRuntimeException {
        return this.queryCount(session, null, null);
    }

    public int queryCount(SqlSession session, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.queryCount(session, dynamicInputValues, null);
    }

    public int queryCount(SqlSession session, Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.queryCount(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues));
    }

    public int queryCount(SqlSession session, Object dynamicInputValues, Object staticInputValues, SqlOrder order, Integer maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.queryCount(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setOrder(order).setMaxTimeout(maxTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queryCount(final SqlSession session, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> queryCount, session=" + session + ", dynamicInputValues=" + dynamicInputValues + ", sqlControl=" + sqlControl);
        }
        this.checkDynamicInputValues(dynamicInputValues);
        final QueryExecutor executor = new QueryExecutor(0);
        Integer count = null;
        try {
            count = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Integer run() {
                    final SqlRuntimeContext runtimeContext = executor.prepareQueryCount(session, dynamicInputValues, sqlControl);
                    if (SqlQueryEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlQueryEngine.this.monitor;
                        return monitorExt.runSql(new SqlMonitor.Runner(){

                            @Override
                            public Integer run() {
                                return executor.executeCount(runtimeContext);
                            }
                        }, Integer.class);
                    }
                    return executor.executeCount(runtimeContext);
                }
            }, Integer.class);
            int n = count;
            return n;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< queryCount, count=" + count);
            }
        }
    }

    public String getSql(Object dynamicInputValues, Object staticInputValues, SqlOrder order) throws SqlProcessorException, SqlRuntimeException {
        return this.getSql(dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setOrder(order));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSql(final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> getSql, dynamicInputValues=" + dynamicInputValues + ", sqlControl=" + sqlControl);
        }
        String sql = null;
        try {
            String string = sql = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public String run() {
                    SqlProcessResult processResult = SqlQueryEngine.this.process(SqlMetaStatement.Type.QUERY, dynamicInputValues, sqlControl);
                    String sql = SqlQueryEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlQueryEngine.this.name, processResult.getSql().toString());
                    return sql;
                }
            }, String.class);
            return string;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< getSql, sql=" + sql);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public SqlMonitor getMonitor() {
        return this.monitor;
    }

    private class QueryExecutor<E> {
        private Integer rownums;
        private List<E> rows;
        private SqlQuery query;
        private SqlMappingResult mappingResult;

        QueryExecutor(List<E> rows) {
            this.rows = rows;
        }

        QueryExecutor(Integer rownums) {
            this.rownums = rownums;
        }

        SqlRuntimeContext prepareQuery(SqlSession session, Class<E> resultClass, Object dynamicInputValues, SqlControl sqlControl) {
            SqlProcessResult processResult = SqlQueryEngine.this.process(SqlMetaStatement.Type.QUERY, dynamicInputValues, sqlControl);
            String sql = SqlQueryEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlQueryEngine.this.name, processResult.getSql().toString());
            this.query = session.createSqlQuery(sql);
            this.query.setLogError(processResult.isLogError());
            if (SqlEngine.getMaxTimeout(sqlControl) != null) {
                this.query.setTimeout(SqlEngine.getMaxTimeout(sqlControl));
            }
            if (SqlEngine.getFetchSize(sqlControl) != null) {
                this.query.setFetchSize(SqlEngine.getFetchSize(sqlControl));
            }
            this.query.setOrdered(SqlEngine.getOrder(sqlControl) != null && SqlEngine.getOrder(sqlControl) != NO_ORDER);
            processResult.setQueryParams(session, this.query);
            this.mappingResult = SqlMappingRule.merge(SqlQueryEngine.this.mapping, processResult);
            this.mappingResult.setQueryResultMapping(resultClass, SqlEngine.getMoreResultClasses(sqlControl), this.query);
            if (SqlEngine.getFirstResult(sqlControl) != null) {
                this.query.setFirstResult(SqlEngine.getFirstResult(sqlControl));
                this.query.setMaxResults(SqlEngine.getMaxResults(sqlControl));
            } else if (SqlEngine.getMaxResults(sqlControl) != null) {
                this.query.setMaxResults(SqlEngine.getMaxResults(sqlControl));
            }
            return this.mappingResult.getRuntimeContext();
        }

        SqlRuntimeContext prepareQueryCount(SqlSession session, Object dynamicInputValues, SqlControl sqlControl) {
            SqlProcessResult processResult = SqlQueryEngine.this.process(SqlMetaStatement.Type.QUERY, dynamicInputValues, sqlControl);
            String sql = SqlQueryEngine.this.pluginFactory.getSqlCountPlugin().sqlCount(SqlQueryEngine.this.name, processResult.getSql());
            this.query = session.createSqlQuery(sql);
            this.query.setLogError(processResult.isLogError());
            SqlQueryEngine.this.typeFactory.getDefaultType().addScalar(this.query, "vysledek", Integer.class);
            if (SqlEngine.getMaxTimeout(sqlControl) != null) {
                this.query.setTimeout(SqlEngine.getMaxTimeout(sqlControl));
            }
            this.query.setOrdered(SqlEngine.getOrder(sqlControl) != null && SqlEngine.getOrder(sqlControl) != NO_ORDER);
            processResult.setQueryParams(session, this.query);
            return processResult.getRuntimeContext();
        }

        List<E> execute(Class<E> resultClass, SqlControl sqlControl, SqlRuntimeContext runtimeContext) {
            Map<String, Object> ids = this.mappingResult.getIds();
            List list = this.query.list(runtimeContext);
            boolean isPrimitiveWrapper = SqlUtils.isPrimitiveWrapper(resultClass);
            for (Object resultRow : list) {
                this.execute(runtimeContext, resultRow, resultClass, sqlControl, null, ids, isPrimitiveWrapper);
            }
            return this.rows;
        }

        Integer execute(final Class<E> resultClass, final SqlControl sqlControl, final SqlRowProcessor<E> sqlRowProcessor, final SqlRuntimeContext runtimeContext) {
            final Map<String, Object> ids = this.mappingResult.getIds();
            final boolean isPrimitiveWrapper = SqlUtils.isPrimitiveWrapper(resultClass);
            this.query.query(runtimeContext, new SqlQuery.SqlQueryRowProcessor(){

                @Override
                public boolean processRow(Object resultRow, int rownum) throws SqlRuntimeException {
                    return QueryExecutor.this.execute(runtimeContext, resultRow, resultClass, sqlControl, sqlRowProcessor, ids, isPrimitiveWrapper);
                }
            });
            return this.rownums;
        }

        Integer executeCount(SqlRuntimeContext runtimeContext) {
            return (Integer)this.query.unique(runtimeContext);
        }

        boolean execute(SqlRuntimeContext runtimeContext, Object resultRow, Class<E> resultClass, SqlControl sqlControl, SqlRowProcessor<E> sqlRowProcessor, Map<String, Object> ids, boolean isPrimitiveWrapper) {
            String idsKey;
            Object[] objectArray;
            Object resultInstance = null;
            if (resultRow instanceof Object[]) {
                objectArray = (Object[])resultRow;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = resultRow;
            }
            Object[] resultValue = objectArray;
            if (SqlQueryEngine.this.logger.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < resultValue.length; ++i) {
                    sb.append("'").append(resultValue[i]).append("' ");
                }
                SqlQueryEngine.this.logger.trace("== SQL execution partial result " + sb.toString());
            }
            boolean changedIdentity = true;
            if (ids != null && ids.containsKey(idsKey = SqlUtils.getIdsKey(resultValue, this.mappingResult.getMainIdentityIndex()))) {
                resultInstance = ids.get(idsKey);
                changedIdentity = false;
            }
            if (changedIdentity) {
                if (!isPrimitiveWrapper) {
                    resultInstance = runtimeContext.getInstance(resultClass);
                    if (resultInstance == null) {
                        throw new SqlRuntimeException("There's problem to instantiate " + resultClass);
                    }
                } else {
                    resultInstance = resultRow;
                }
            }
            if (!isPrimitiveWrapper) {
                this.mappingResult.setQueryResultData(resultInstance, resultValue, ids, SqlEngine.getMoreResultClasses(sqlControl));
            }
            if (changedIdentity) {
                if (sqlRowProcessor != null) {
                    this.rownums = this.rownums + 1;
                    if (!sqlRowProcessor.processRow(resultInstance, this.rownums)) {
                        return false;
                    }
                } else {
                    this.rows.add(resultInstance);
                }
                if (ids != null) {
                    idsKey = SqlUtils.getIdsKey(resultValue, this.mappingResult.getMainIdentityIndex());
                    ids.put(idsKey, resultInstance);
                }
            }
            return true;
        }
    }
}

