/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.type;

import org.slf4j.Logger;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.type.SqlTypeFactory;

public interface SqlMetaType {
    public Object getProviderSqlType();

    public void addScalar(SqlTypeFactory var1, SqlQuery var2, String var3, Class<?> ... var4);

    default public void addScalarEntryLog(Logger logger, SqlMetaType sqlMetaType, SqlTypeFactory typeFactory, SqlQuery query, String dbName, Class<?> ... attributeTypes) {
        if (logger.isTraceEnabled()) {
            logger.trace(">>> addScalar for META type " + this + ": query=" + query + ", dbName=" + dbName + ", attributeTypes=" + attributeTypes);
        }
    }

    public void setResult(SqlRuntimeContext var1, Object var2, String var3, Object var4, boolean var5) throws SqlRuntimeException;

    default public void setResultEntryLog(Logger logger, SqlMetaType sqlMetaType, SqlRuntimeContext runtimeCtx, Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) {
        if (logger.isTraceEnabled()) {
            logger.trace(">>> setResult for META type " + sqlMetaType + ": resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue + ", resultType" + (resultValue != null ? resultValue.getClass() : null));
        }
    }

    public void setParameter(SqlRuntimeContext var1, SqlQuery var2, String var3, Object var4, boolean var5, Class<?> ... var6) throws SqlRuntimeException;

    default public void setParameterEntryLog(Logger logger, SqlMetaType sqlMetaType, SqlRuntimeContext runtimeCtx, SqlQuery query, String paramName, Object inputValue, boolean ingoreError, Class<?> ... inputTypes) {
        if (logger.isTraceEnabled()) {
            logger.trace(">>> setParameter for META type " + this + ": paramName=" + paramName + ", inputValue=" + inputValue + ", inputTypes=" + inputTypes);
        }
    }

    default public void error(Logger logger, boolean ingoreError, String msg) {
        if (!ingoreError) {
            throw new SqlRuntimeException(msg);
        }
        logger.error(msg);
    }
}

