// $ANTLR 3.5.2 org/sqlproc/engine/impl/SqlProcessorLazy.g 2017-05-07 19:25:32
 
package org.sqlproc.engine.impl;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import org.sqlproc.engine.type.SqlTypeFactory;
import org.sqlproc.engine.type.SqlMetaType;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class SqlProcessorLazyParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "AND", "AT", "BAND", "BOR", "CARET", 
		"COLON", "COMMA", "DIGIT", "DOT", "EQUALS", "ESC_AT", "ESC_BOR", "ESC_CHAR", 
		"ESC_COLON", "ESC_DOT", "ESC_HASH", "ESC_LBRACE", "ESC_PERCENT", "ESC_RBRACE", 
		"ESC_SEMICOLON", "ESC_SLASH", "ESC_STRING", "HASH", "IDENT", "IDENT_DOT", 
		"LBRACE", "LESS_THAN", "LPAREN", "MAPPING", "MINUS", "ML_COMMENT", "MORE_THAN", 
		"NOT", "NUMBER", "OPTION", "OR", "PERCENT", "PLUS", "QUESTI", "RBRACE", 
		"REST", "RPAREN", "SEMICOLON", "SL_COMMENT", "STATEMENT", "STRING", "WS"
	};
	public static final int EOF=-1;
	public static final int AND=4;
	public static final int AT=5;
	public static final int BAND=6;
	public static final int BOR=7;
	public static final int CARET=8;
	public static final int COLON=9;
	public static final int COMMA=10;
	public static final int DIGIT=11;
	public static final int DOT=12;
	public static final int EQUALS=13;
	public static final int ESC_AT=14;
	public static final int ESC_BOR=15;
	public static final int ESC_CHAR=16;
	public static final int ESC_COLON=17;
	public static final int ESC_DOT=18;
	public static final int ESC_HASH=19;
	public static final int ESC_LBRACE=20;
	public static final int ESC_PERCENT=21;
	public static final int ESC_RBRACE=22;
	public static final int ESC_SEMICOLON=23;
	public static final int ESC_SLASH=24;
	public static final int ESC_STRING=25;
	public static final int HASH=26;
	public static final int IDENT=27;
	public static final int IDENT_DOT=28;
	public static final int LBRACE=29;
	public static final int LESS_THAN=30;
	public static final int LPAREN=31;
	public static final int MAPPING=32;
	public static final int MINUS=33;
	public static final int ML_COMMENT=34;
	public static final int MORE_THAN=35;
	public static final int NOT=36;
	public static final int NUMBER=37;
	public static final int OPTION=38;
	public static final int OR=39;
	public static final int PERCENT=40;
	public static final int PLUS=41;
	public static final int QUESTI=42;
	public static final int RBRACE=43;
	public static final int REST=44;
	public static final int RPAREN=45;
	public static final int SEMICOLON=46;
	public static final int SL_COMMENT=47;
	public static final int STATEMENT=48;
	public static final int STRING=49;
	public static final int WS=50;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public SqlProcessorLazyParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public SqlProcessorLazyParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return SqlProcessorLazyParser.tokenNames; }
	@Override public String getGrammarFileName() { return "org/sqlproc/engine/impl/SqlProcessorLazy.g"; }


	  private Token getLastToken() {
	    return input.LT(-1);
	  }

	  private Stack artifactName = new Stack();
	  private Stack partialErrors = new Stack();
	  private List<ErrorMsg> errors = new ArrayList<ErrorMsg>();
	  
	  public List<ErrorMsg> getErrors() {
	    return errors;
	  }

	  @Override
	  public void reportError(RecognitionException e) {
	    String msg = super.getErrorMessage(e,tokenNames);
	    if ( artifactName.size()>0 ) {
	      String name = (String)artifactName.peek();
	      partialErrors.push(ParserUtils.create(name,msg,e,tokenNames));
	    }
	    else {
	      errors.add(ParserUtils.create(null,msg,e,tokenNames));
	    }
	  }
	  
	  String getText(Token token) {
	    if (token == null)
	      return null;
	    return token.getText();
	  }
	  
	  void add(StringBuilder text) {
	    int type = getLastToken().getType();
	    if (type == ESC_CHAR) {
	      text.append(getLastToken().getText().substring(1));
	    } 
	    else if (type == WS) {
	      String s = getLastToken().getText();
	      for (int i = 0, l = s.length(); i < l; i++) {
	        char c = s.charAt(i);
	        if (c == '\n' || c == '\r')
	          continue;
	        text.append(c);
	      }
	    } 
	    else {
	      text.append(getLastToken().getText());
	    }
	  }
	  
	  void addText(Object target, StringBuilder text) {
	    ParserUtils.addText(target, text);
	  }
	  
	  void addColumn(Object target, SqlMappingItem col, StringBuilder text) {
	    ParserUtils.addColumn(target, col, text);
	  }
	  
	  SqlMappingItem newColumn(String col) {
	    return ParserUtils.newColumn(col);
	  }
	  
	  void addColumnAttr(SqlMappingItem item, Token col) {
	    ParserUtils.addColumnAttr(item, col.getText());
	  }
	  
	  void addDatabaseColumn(Object target, SqlDatabaseColumn dbcol, StringBuilder text) {
	    ParserUtils.addDatabaseColumn(target, dbcol, text);
	  }
	  
	  SqlDatabaseColumn newDatabaseColumn(Token col) {
	    return ParserUtils.newDatabaseColumn(col.getText());
	  }
	  
	  void addDatabaseTable(Object target, SqlDatabaseTable dbtab, StringBuilder text) {
	    ParserUtils.addDatabaseTable(target, dbtab, text);
	  }
	  
	  SqlDatabaseTable newDatabaseTable(Token col) {
	    return ParserUtils.newDatabaseTable(col.getText());
	  }

	 SqlMetaOperator lastOperator = null;
	  
	  void addIdent(Object target, SqlMetaIdent ident, StringBuilder text) {
	    ParserUtils.addIdent(target, ident, text, lastOperator);
	    lastOperator = null;
	  }
	  
	  SqlMetaIdent newIdent(Token ident, Token modeIdent, Token caseIdent) {
	    return ParserUtils.newIdent(ident.getText(), getText(modeIdent), getText(caseIdent));
	  }

	  void addConstant(Object target, SqlMetaConst cnst, StringBuilder text) {
	    ParserUtils.addConstant(target, cnst, text, lastOperator);
	    lastOperator = null;
	  }
	  
	  SqlMetaConst newConstant(Token cnst, Token caseConversion) {
	    return ParserUtils.newConstant(cnst.getText(), getText(caseConversion));
	  }
	  
	  void addOperator(Object target, SqlMetaOperator metaOper, StringBuilder text) {
	    ParserUtils.addOperator(target, metaOper, text);
	    lastOperator = metaOper;
	  }

	  SqlMetaOperator newIdentOperator(Token ident) {
	    return ParserUtils.newOperator(true, ident.getText());
	  }
	  
	  SqlMetaOperator newConstOperator(Token cnst) {
	    return ParserUtils.newOperator(false, cnst.getText());
	  }
	  
	  void addOperator(SqlMetaLogExpr expr, boolean isAnd) {
	    if (isAnd)
	      expr.addElement(new SqlMetaLogOperator(SqlMetaLogOperator.Type.AND));
	    else
	      expr.addElement(new SqlMetaLogOperator(SqlMetaLogOperator.Type.OR));
	  }

	  void addModifier(SqlTypeFactory typeFactory, SqlMappingItem item, String modifier) {
	    ParserUtils.addModifier(item, typeFactory, modifier);
	  }

	  void addModifier(SqlTypeFactory typeFactory, SqlMappingItem item, String modifier, String attrName) {
	    ParserUtils.addModifier(item, typeFactory, modifier, attrName);
	  }

	  void addModifier(SqlTypeFactory typeFactory, SqlMetaIdent item, String modifier, Token not) {
	    if (not != null)
	      modifier = "not" + modifier;
	    ParserUtils.addModifier(item, typeFactory, modifier);
	  }

	  void addModifier(SqlTypeFactory typeFactory, SqlMetaConst item, String modifier, Token not) {
	    if (not != null)
	      modifier = "not" + modifier;
	    ParserUtils.addModifier(item, typeFactory, modifier);
	  }
	  
	  boolean doSkip(Set<String> onlyStatements, String name) {
	    if (onlyStatements == null || onlyStatements.isEmpty())
	      return false;
	    return !onlyStatements.contains(name);
	  }
	  
	  List<ErrorMsg> getPartialErrors() {
	    if (partialErrors.size()==0)
	      return null;
	    List<ErrorMsg> errorsList = new ArrayList<ErrorMsg>();
	    while ( partialErrors.size()>0 ) {
	      ErrorMsg errorMsg = (ErrorMsg) partialErrors.pop(); 
	      errorsList.add(errorMsg);
	    }
	    return errorsList;
	  }
	  
	  boolean addStatement(SqlProcessor processor, String type, String name, String statement, List<String> activeFilters, String... filters) {
	    List<ErrorMsg> errorsList = getPartialErrors();
	    processor.addMetaStatement(type, name, statement, null, errorsList, activeFilters, filters);
	    return errorsList == null;
	  }
	  
	  boolean addMapping(SqlProcessor processor, String type, String name, String mapping, List<String> activeFilters, String... filters) {
	    List<ErrorMsg> errorsList = getPartialErrors();
	    processor.addMappingRule(type, name, mapping, null, errorsList, activeFilters, filters);
	    return errorsList == null;
	  }
	  
	  boolean add(SqlProcessor processor, String type, String name, String feature, List<String> activeFilters, String... filters) {
	    List<ErrorMsg> errorsList = getPartialErrors();
	    processor.addFeature(type, name, feature, errorsList, activeFilters, filters);
	    return errorsList == null;
	  }
	  
	  SqlMetaIfItem newSqlMetaIfItem() {
	    lastOperator = null;
	    return new SqlMetaIfItem();
	  }
	  
	  SqlMetaStatement newSqlMetaStatement() {
	    lastOperator = null;
	    return new SqlMetaStatement();
	  }



	// $ANTLR start "parse"
	// org/sqlproc/engine/impl/SqlProcessorLazy.g:223:1: parse : parse2[org.sqlproc.engine.jdbc.type.JdbcTypeFactory.getInstance(), new java.util.HashMap<String, Object>(), new java.util.HashSet<String>(), new String[] {}] ;
	public final void parse() throws RecognitionException {
		try {
			// org/sqlproc/engine/impl/SqlProcessorLazy.g:223:7: ( parse2[org.sqlproc.engine.jdbc.type.JdbcTypeFactory.getInstance(), new java.util.HashMap<String, Object>(), new java.util.HashSet<String>(), new String[] {}] )
			// org/sqlproc/engine/impl/SqlProcessorLazy.g:224:9: parse2[org.sqlproc.engine.jdbc.type.JdbcTypeFactory.getInstance(), new java.util.HashMap<String, Object>(), new java.util.HashSet<String>(), new String[] {}]
			{
			pushFollow(FOLLOW_parse2_in_parse52);
			parse2(org.sqlproc.engine.jdbc.type.JdbcTypeFactory.getInstance(), new java.util.HashMap<String, Object>(), new java.util.HashSet<String>(), new String[] {});
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "parse"



	// $ANTLR start "parse2"
	// org/sqlproc/engine/impl/SqlProcessorLazy.g:227:1: parse2[SqlTypeFactory _typeFactory, Map<String, Object> defaultFeatures, Set<String> onlyStatements, String[] filters] returns [SqlProcessor processor] : ( WS )* ( (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) )+ EOF ;
	public final SqlProcessor parse2(SqlTypeFactory _typeFactory, Map<String, Object> defaultFeatures, Set<String> onlyStatements, String[] filters) throws RecognitionException {
		SqlProcessor processor = null;


		Token name=null;
		Token type=null;
		Token filter=null;
		StringBuilder text =null;

		processor = new SqlProcessor(defaultFeatures, onlyStatements); boolean skip; List<String> activeFilters;
		try {
			// org/sqlproc/engine/impl/SqlProcessorLazy.g:229:9: ( ( WS )* ( (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) )+ EOF )
			// org/sqlproc/engine/impl/SqlProcessorLazy.g:230:9: ( WS )* ( (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) )+ EOF
			{
			// org/sqlproc/engine/impl/SqlProcessorLazy.g:230:9: ( WS )*
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( (LA1_0==WS) ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessorLazy.g:230:9: WS
					{
					match(input,WS,FOLLOW_WS_in_parse293); 
					}
					break;

				default :
					break loop1;
				}
			}

			// org/sqlproc/engine/impl/SqlProcessorLazy.g:230:13: ( (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) )+
			int cnt8=0;
			loop8:
			while (true) {
				int alt8=4;
				int LA8_0 = input.LA(1);
				if ( (LA8_0==IDENT) ) {
					int LA8_2 = input.LA(2);
					if ( (LA8_2==LPAREN) ) {
						switch ( input.LA(3) ) {
						case OPTION:
							{
							alt8=3;
							}
							break;
						case STATEMENT:
							{
							alt8=1;
							}
							break;
						case MAPPING:
							{
							alt8=2;
							}
							break;
						}
					}

				}

				switch (alt8) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessorLazy.g:231:10: (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* )
					{
					// org/sqlproc/engine/impl/SqlProcessorLazy.g:231:10: (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* )
					// org/sqlproc/engine/impl/SqlProcessorLazy.g:231:11: name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )*
					{
					name=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse2110); 
					skip=doSkip(onlyStatements,(name!=null?name.getText():null));
					match(input,LPAREN,FOLLOW_LPAREN_in_parse2114); 
					type=(Token)match(input,STATEMENT,FOLLOW_STATEMENT_in_parse2118); 
					activeFilters = new ArrayList<String>();
					// org/sqlproc/engine/impl/SqlProcessorLazy.g:231:129: ( COMMA filter= IDENT )*
					loop2:
					while (true) {
						int alt2=2;
						int LA2_0 = input.LA(1);
						if ( (LA2_0==COMMA) ) {
							alt2=1;
						}

						switch (alt2) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessorLazy.g:231:130: COMMA filter= IDENT
							{
							match(input,COMMA,FOLLOW_COMMA_in_parse2123); 
							filter=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse2127); 
							activeFilters.add((filter!=null?filter.getText():null));
							}
							break;

						default :
							break loop2;
						}
					}

					match(input,RPAREN,FOLLOW_RPAREN_in_parse2133); 
					match(input,EQUALS,FOLLOW_EQUALS_in_parse2135); 
					pushFollow(FOLLOW_option_in_parse2151);
					text=option((name!=null?name.getText():null));
					state._fsp--;

					addStatement(processor, (type!=null?type.getText():null), (name!=null?name.getText():null), text.toString(), activeFilters, filters);
					match(input,SEMICOLON,FOLLOW_SEMICOLON_in_parse2156); 
					// org/sqlproc/engine/impl/SqlProcessorLazy.g:232:138: ( WS )*
					loop3:
					while (true) {
						int alt3=2;
						int LA3_0 = input.LA(1);
						if ( (LA3_0==WS) ) {
							alt3=1;
						}

						switch (alt3) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessorLazy.g:232:138: WS
							{
							match(input,WS,FOLLOW_WS_in_parse2158); 
							}
							break;

						default :
							break loop3;
						}
					}

					}

					}
					break;
				case 2 :
					// org/sqlproc/engine/impl/SqlProcessorLazy.g:233:12: (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* )
					{
					// org/sqlproc/engine/impl/SqlProcessorLazy.g:233:12: (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* )
					// org/sqlproc/engine/impl/SqlProcessorLazy.g:233:13: name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )*
					{
					name=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse2176); 
					skip=doSkip(onlyStatements,(name!=null?name.getText():null));
					match(input,LPAREN,FOLLOW_LPAREN_in_parse2180); 
					type=(Token)match(input,MAPPING,FOLLOW_MAPPING_in_parse2184); 
					activeFilters = new ArrayList<String>();
					// org/sqlproc/engine/impl/SqlProcessorLazy.g:233:129: ( COMMA filter= IDENT )*
					loop4:
					while (true) {
						int alt4=2;
						int LA4_0 = input.LA(1);
						if ( (LA4_0==COMMA) ) {
							alt4=1;
						}

						switch (alt4) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessorLazy.g:233:130: COMMA filter= IDENT
							{
							match(input,COMMA,FOLLOW_COMMA_in_parse2189); 
							filter=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse2193); 
							activeFilters.add((filter!=null?filter.getText():null));
							}
							break;

						default :
							break loop4;
						}
					}

					match(input,RPAREN,FOLLOW_RPAREN_in_parse2199); 
					match(input,EQUALS,FOLLOW_EQUALS_in_parse2201); 
					pushFollow(FOLLOW_option_in_parse2217);
					text=option((name!=null?name.getText():null));
					state._fsp--;

					addMapping(processor, (type!=null?type.getText():null), (name!=null?name.getText():null), text.toString(), activeFilters, filters);
					match(input,SEMICOLON,FOLLOW_SEMICOLON_in_parse2222); 
					// org/sqlproc/engine/impl/SqlProcessorLazy.g:234:136: ( WS )*
					loop5:
					while (true) {
						int alt5=2;
						int LA5_0 = input.LA(1);
						if ( (LA5_0==WS) ) {
							alt5=1;
						}

						switch (alt5) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessorLazy.g:234:136: WS
							{
							match(input,WS,FOLLOW_WS_in_parse2224); 
							}
							break;

						default :
							break loop5;
						}
					}

					}

					}
					break;
				case 3 :
					// org/sqlproc/engine/impl/SqlProcessorLazy.g:235:12: (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* )
					{
					// org/sqlproc/engine/impl/SqlProcessorLazy.g:235:12: (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* )
					// org/sqlproc/engine/impl/SqlProcessorLazy.g:235:13: name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )*
					{
					name=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse2242); 
					match(input,LPAREN,FOLLOW_LPAREN_in_parse2244); 
					type=(Token)match(input,OPTION,FOLLOW_OPTION_in_parse2248); 
					activeFilters = new ArrayList<String>();
					// org/sqlproc/engine/impl/SqlProcessorLazy.g:235:86: ( COMMA filter= IDENT )*
					loop6:
					while (true) {
						int alt6=2;
						int LA6_0 = input.LA(1);
						if ( (LA6_0==COMMA) ) {
							alt6=1;
						}

						switch (alt6) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessorLazy.g:235:87: COMMA filter= IDENT
							{
							match(input,COMMA,FOLLOW_COMMA_in_parse2253); 
							filter=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse2257); 
							activeFilters.add((filter!=null?filter.getText():null));
							}
							break;

						default :
							break loop6;
						}
					}

					match(input,RPAREN,FOLLOW_RPAREN_in_parse2263); 
					match(input,EQUALS,FOLLOW_EQUALS_in_parse2265); 
					pushFollow(FOLLOW_option_in_parse2281);
					text=option((name!=null?name.getText():null));
					state._fsp--;

					add(processor, (type!=null?type.getText():null), (name!=null?name.getText():null), text.toString(), activeFilters, filters);
					match(input,SEMICOLON,FOLLOW_SEMICOLON_in_parse2286); 
					// org/sqlproc/engine/impl/SqlProcessorLazy.g:236:129: ( WS )*
					loop7:
					while (true) {
						int alt7=2;
						int LA7_0 = input.LA(1);
						if ( (LA7_0==WS) ) {
							alt7=1;
						}

						switch (alt7) {
						case 1 :
							// org/sqlproc/engine/impl/SqlProcessorLazy.g:236:129: WS
							{
							match(input,WS,FOLLOW_WS_in_parse2288); 
							}
							break;

						default :
							break loop7;
						}
					}

					}

					}
					break;

				default :
					if ( cnt8 >= 1 ) break loop8;
					EarlyExitException eee = new EarlyExitException(8, input);
					throw eee;
				}
				cnt8++;
			}

			match(input,EOF,FOLLOW_EOF_in_parse2303); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return processor;
	}
	// $ANTLR end "parse2"



	// $ANTLR start "option"
	// org/sqlproc/engine/impl/SqlProcessorLazy.g:240:1: option[String name] returns [StringBuilder text] : (~ ( SEMICOLON ) )+ ;
	public final StringBuilder option(String name) throws RecognitionException {
		StringBuilder text = null;


		artifactName.push(name); text = new StringBuilder();
		try {
			// org/sqlproc/engine/impl/SqlProcessorLazy.g:243:2: ( (~ ( SEMICOLON ) )+ )
			// org/sqlproc/engine/impl/SqlProcessorLazy.g:243:4: (~ ( SEMICOLON ) )+
			{
			// org/sqlproc/engine/impl/SqlProcessorLazy.g:243:4: (~ ( SEMICOLON ) )+
			int cnt9=0;
			loop9:
			while (true) {
				int alt9=2;
				int LA9_0 = input.LA(1);
				if ( ((LA9_0 >= AND && LA9_0 <= RPAREN)||(LA9_0 >= SL_COMMENT && LA9_0 <= WS)) ) {
					alt9=1;
				}

				switch (alt9) {
				case 1 :
					// org/sqlproc/engine/impl/SqlProcessorLazy.g:243:5: ~ ( SEMICOLON )
					{
					if ( (input.LA(1) >= AND && input.LA(1) <= RPAREN)||(input.LA(1) >= SL_COMMENT && input.LA(1) <= WS) ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					add(text);
					}
					break;

				default :
					if ( cnt9 >= 1 ) break loop9;
					EarlyExitException eee = new EarlyExitException(9, input);
					throw eee;
				}
				cnt9++;
			}

			}

			 artifactName.pop();
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return text;
	}
	// $ANTLR end "option"

	// Delegated rules



	public static final BitSet FOLLOW_parse2_in_parse52 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_WS_in_parse293 = new BitSet(new long[]{0x0004000008000000L});
	public static final BitSet FOLLOW_IDENT_in_parse2110 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_LPAREN_in_parse2114 = new BitSet(new long[]{0x0001000000000000L});
	public static final BitSet FOLLOW_STATEMENT_in_parse2118 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_COMMA_in_parse2123 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_IDENT_in_parse2127 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_RPAREN_in_parse2133 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_EQUALS_in_parse2135 = new BitSet(new long[]{0x0007BFFFFFFFFFF0L});
	public static final BitSet FOLLOW_option_in_parse2151 = new BitSet(new long[]{0x0000400000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_parse2156 = new BitSet(new long[]{0x0004000008000000L});
	public static final BitSet FOLLOW_WS_in_parse2158 = new BitSet(new long[]{0x0004000008000000L});
	public static final BitSet FOLLOW_IDENT_in_parse2176 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_LPAREN_in_parse2180 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_MAPPING_in_parse2184 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_COMMA_in_parse2189 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_IDENT_in_parse2193 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_RPAREN_in_parse2199 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_EQUALS_in_parse2201 = new BitSet(new long[]{0x0007BFFFFFFFFFF0L});
	public static final BitSet FOLLOW_option_in_parse2217 = new BitSet(new long[]{0x0000400000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_parse2222 = new BitSet(new long[]{0x0004000008000000L});
	public static final BitSet FOLLOW_WS_in_parse2224 = new BitSet(new long[]{0x0004000008000000L});
	public static final BitSet FOLLOW_IDENT_in_parse2242 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_LPAREN_in_parse2244 = new BitSet(new long[]{0x0000004000000000L});
	public static final BitSet FOLLOW_OPTION_in_parse2248 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_COMMA_in_parse2253 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_IDENT_in_parse2257 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_RPAREN_in_parse2263 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_EQUALS_in_parse2265 = new BitSet(new long[]{0x0007BFFFFFFFFFF0L});
	public static final BitSet FOLLOW_option_in_parse2281 = new BitSet(new long[]{0x0000400000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_parse2286 = new BitSet(new long[]{0x0004000008000000L});
	public static final BitSet FOLLOW_WS_in_parse2288 = new BitSet(new long[]{0x0004000008000000L});
	public static final BitSet FOLLOW_EOF_in_parse2303 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_option331 = new BitSet(new long[]{0x0007BFFFFFFFFFF2L});
}
