/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.type;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.type.OutValueSetter;
import org.sqlproc.engine.type.SqlDefaultType;

public abstract class SqlLocalDateType
extends SqlDefaultType {
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[]{LocalDate.class};
    }

    @Override
    public String[] getMetaTypes() {
        return new String[]{"LOCALDATE"};
    }

    @Override
    public void setResult(SqlRuntimeContext runtimeCtx, Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        this.setResultEntryLog(this.logger, this, runtimeCtx, resultInstance, attributeName, resultValue, ingoreError);
        if (resultValue == null) {
            if (runtimeCtx.simpleSetAttribute(resultInstance, attributeName, null, LocalDate.class)) {
                return;
            }
            this.error(this.logger, ingoreError, "There's no setter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
            return;
        }
        if (resultValue instanceof Date) {
            if (runtimeCtx.simpleSetAttribute(resultInstance, attributeName, ((Date)resultValue).toLocalDate(), LocalDate.class)) {
                return;
            }
            this.error(this.logger, ingoreError, "There's no setter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
            return;
        }
        this.error(this.logger, ingoreError, "Incorrect localdate " + resultValue + " for " + attributeName + " in " + resultInstance);
    }

    @Override
    public Object getResult(SqlRuntimeContext runtimeCtx, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        if (resultValue == null) {
            return null;
        }
        if (resultValue instanceof Timestamp) {
            return ((Date)resultValue).toLocalDate();
        }
        return resultValue;
    }

    @Override
    public void setParameter(SqlRuntimeContext runtimeCtx, SqlQuery query, String paramName, Object inputValue, boolean ingoreError, Class<?> ... inputTypes) throws SqlRuntimeException {
        this.setParameterEntryLog(this.logger, this, runtimeCtx, query, paramName, inputValue, ingoreError, inputTypes);
        if (inputValue == null) {
            query.setParameter(paramName, inputValue, this.getProviderSqlType(), new Class[0]);
        } else if (inputValue instanceof LocalDate) {
            Date value = Date.valueOf((LocalDate)inputValue);
            query.setParameter(paramName, value, this.getProviderSqlType(), new Class[0]);
        } else if (inputValue instanceof OutValueSetter) {
            final OutValueSetter outValueSetter = (OutValueSetter)inputValue;
            OutValueSetter _outValueSetter = new OutValueSetter(){

                @Override
                public Object setOutValue(Object outValue) {
                    if (outValue == null) {
                        return outValueSetter.setOutValue(null);
                    }
                    if (outValue instanceof Date) {
                        LocalDate result = ((Date)outValue).toLocalDate();
                        return outValueSetter.setOutValue(result);
                    }
                    throw new RuntimeException("Incorret function output value for localdate");
                }
            };
            query.setParameter(paramName, _outValueSetter, this.getProviderSqlType(), new Class[0]);
        } else {
            this.error(this.logger, ingoreError, "Incorrect localdate " + inputValue + " for " + paramName);
        }
    }
}

