/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Properties properties;

    public PropertiesLoader(String fileName, Class<?> loaderClass) {
        this.properties = this.load(fileName, loaderClass);
    }

    public static Properties getProperties(Class<?> loaderClass, String fileName) {
        PropertiesLoader loader = new PropertiesLoader(fileName, loaderClass);
        return loader.getProperties();
    }

    public PropertiesLoader(List<String> fileNames, Class<?> loaderClass) {
        this.properties = new Properties();
        if (fileNames == null || fileNames.isEmpty()) {
            return;
        }
        for (String fileName : fileNames) {
            Properties props = this.load(fileName, loaderClass);
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                this.properties.setProperty((String)e.getKey(), (String)e.getValue());
            }
        }
    }

    public static Properties getProperties(Class<?> loaderClass, String ... fileNames) {
        ArrayList<String> propsNames = new ArrayList<String>();
        Collections.addAll(propsNames, fileNames);
        PropertiesLoader loader = new PropertiesLoader(propsNames, loaderClass);
        return loader.getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties load(String fileName, Class<?> loaderClass) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> load, fileName=" + fileName + ", loaderClass=" + loaderClass);
        }
        try {
            Object configFile = "/" + fileName;
            InputStream is = loaderClass.getResourceAsStream((String)configFile);
            if (is == null) {
                configFile = fileName;
                is = loaderClass.getResourceAsStream((String)configFile);
            }
            if (is == null) {
                try {
                    configFile = "/" + fileName;
                    is = new FileInputStream((String)configFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (is == null) {
                try {
                    configFile = System.getProperty("user.home") + (String)configFile;
                    is = new FileInputStream((String)configFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            Properties properties = new Properties();
            if (is != null) {
                try {
                    properties.load(is);
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< load, properties=" + this.properties);
            }
        }
    }

    public String get(String name) {
        return this.properties.getProperty(name);
    }

    public Properties getProperties() {
        return this.properties;
    }
}

