/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlFeature;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.SqlMappingAttribute;
import org.sqlproc.engine.impl.SqlMappingIdentity;
import org.sqlproc.engine.impl.SqlMetaElement;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.plugin.BeanUtilsPlugin;
import org.sqlproc.engine.type.SqlMetaType;

class SqlMappingItem
implements SqlMetaElement {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<SqlMappingAttribute> attributes;
    private Map<String, SqlMappingAttribute> attributesMap;
    private String dbName;
    private StringBuilder fullName;
    private SqlType sqlType;
    private boolean identity;
    Map<String, String> values = new HashMap<String, String>();
    private static Set<String> CONTAINER_TYPES = new HashSet<String>();

    SqlMappingItem(String dbName) {
        this.attributes = new ArrayList<SqlMappingAttribute>();
        this.attributesMap = new HashMap<String, SqlMappingAttribute>();
        this.sqlType = new SqlType();
        this.dbName = dbName;
        this.fullName = new StringBuilder();
    }

    String getDbName() {
        return this.dbName;
    }

    SqlMappingAttribute addAttributeName(String name) {
        String[] names = name.split("=");
        if (this.fullName.length() > 0) {
            this.fullName.append(".");
        }
        this.fullName.append(names[0]);
        SqlMappingAttribute attr = new SqlMappingAttribute(this, this.fullName.toString(), names[0]);
        if (names.length > 1) {
            attr.setValues("type", names[1]);
        }
        if (names.length > 2) {
            attr.setValues("gtype", names[2]);
        }
        this.attributes.add(attr);
        this.attributesMap.put(this.fullName.toString(), attr);
        return attr;
    }

    SqlMappingAttribute setAttributeValue(String attrName, String value) {
        String[] values = value.split("=");
        SqlMappingAttribute attr = this.attributesMap.get(attrName);
        if (values.length > 1) {
            attr.setValues("gtype", values[1]);
        } else {
            attr.setValues("type", values[0]);
        }
        return attr;
    }

    List<SqlMappingAttribute> getAttributes() {
        return this.attributes;
    }

    void setAttributes(List<SqlMappingAttribute> attributes) {
        this.attributes = attributes;
    }

    void setAttributesMap(Map<String, SqlMappingAttribute> attributesMap) {
        this.attributesMap = attributesMap;
    }

    boolean isIdentity(SqlProcessContext ctx) {
        if (this.identity) {
            return true;
        }
        String id = ctx.getFeature(SqlFeature.ID);
        return id != null && id.equalsIgnoreCase(this.getName());
    }

    String getFullName() {
        if (this.fullName.length() > 0) {
            return this.fullName.toString();
        }
        return this.dbName;
    }

    String getName() {
        return this.attributes.isEmpty() ? this.dbName : this.attributes.get(this.attributes.size() - 1).getName();
    }

    void setMetaType(String metaTypeName, SqlMetaType metaType) {
        this.sqlType = new SqlType(metaTypeName, metaType);
    }

    SqlType getSqlType() {
        return this.sqlType;
    }

    void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    void setValues(String value, String value2) {
        this.setValues(null, value, value2);
    }

    void setValues(String name, String value, String value2) {
        int ix = -1;
        if (value2 == null && (ix = value.indexOf(61)) >= 0) {
            value2 = value.substring(ix + 1);
            value = value.substring(0, ix);
        }
        if (value2 == null) {
            if ("id".equalsIgnoreCase(value)) {
                this.identity = true;
            } else {
                this.sqlType.setValue(value);
            }
        } else if (name == null) {
            this.values.put(value, value2);
        } else {
            this.values.put(name + value, value2);
        }
    }

    void setQueryResultMapping(SqlProcessContext ctx, Class<?> resultClass, Map<String, Class<?>> moreResultClasses, SqlQuery query) throws SqlRuntimeException {
        String typeName;
        SqlMetaType mtype;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>>  setQueryResultMapping, fullName=" + this.getFullName() + ", resultClass=" + String.valueOf(resultClass) + ", moreResultClasses=" + String.valueOf(moreResultClasses));
        }
        if (!((mtype = this.sqlType.getMetaType(ctx)).getProviderSqlType() == null || ctx.isFeature(SqlFeature.COLLECTIONS_ARE_STANDARD_TYPES) && CONTAINER_TYPES.contains(this.sqlType.getMetaTypeName().toUpperCase()))) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("<<<  setQueryResultMapping, fullName=" + this.getFullName() + ", dbName=" + this.dbName + ", metaType=" + String.valueOf(this.sqlType.getMetaType(ctx)));
            }
            this.sqlType.getMetaType(ctx).addScalar(ctx.getTypeFactory(), query, this.dbName, null);
            return;
        }
        int count = this.attributes.size();
        boolean exit = false;
        Class<?> objClass = resultClass;
        for (int i = 0; i < count - 1 && !exit; ++i) {
            Class<?> typeClass;
            SqlMappingAttribute attr = this.attributes.get(i);
            String name = attr.getName();
            BeanUtilsPlugin.GetterType rt = ctx.getGetterType(objClass, name);
            if (rt != null) {
                objClass = rt.type;
            } else if (ctx.isFeature(SqlFeature.IGNORE_INPROPER_OUT)) {
                this.logger.error("There's no getter for '" + name + "' in " + String.valueOf(objClass) + ", complete attribute name is '" + attr.getFullName() + "'");
                exit = true;
            } else {
                throw new SqlRuntimeException("There's no getter for '" + name + "' in " + String.valueOf(objClass) + ", complete attribute name is '" + attr.getFullName() + "'");
            }
            if (exit) continue;
            if (SqlUtils.isCollection(objClass)) {
                typeName = moreResultClasses != null ? this.values.get(attr.getFullName() + "gtype") : null;
                Class<?> clazz = typeClass = typeName != null ? moreResultClasses.get(typeName) : null;
                if (typeClass == null) {
                    typeClass = rt.typeClass;
                }
                if (typeClass != null) {
                    objClass = typeClass;
                    continue;
                }
                if (ctx.isFeature(SqlFeature.IGNORE_INPROPER_OUT)) {
                    this.logger.error("There's no generic type defined for collection " + String.valueOf(objClass) + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
                    exit = true;
                    continue;
                }
                throw new SqlRuntimeException("There's no generic type defined for collection " + String.valueOf(objClass) + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
            }
            if (moreResultClasses == null) continue;
            typeName = moreResultClasses != null ? this.values.get(attr.getFullName() + "gtype") : null;
            Class<?> clazz = typeClass = typeName != null ? moreResultClasses.get(typeName) : null;
            if (typeClass == null) continue;
            objClass = typeClass;
        }
        boolean isPrimitiveWrapper = SqlUtils.isPrimitiveWrapper(resultClass);
        Class<?> attributeType = null;
        Class<?>[] attributeParameterizedTypes = null;
        Class<?> attributeParameterizedType = null;
        attributeType = isPrimitiveWrapper ? objClass : ctx.getAttributeType(objClass, this.getName());
        if (SqlUtils.isCollection(attributeType) && ctx.isFeature(SqlFeature.COLLECTIONS_ARE_STANDARD_TYPES)) {
            typeName = this.values.get(this.getFullName() + "gtype");
            if (typeName != null && moreResultClasses != null) {
                attributeParameterizedType = moreResultClasses.get(typeName);
            }
            if (attributeParameterizedType == null) {
                attributeParameterizedTypes = ctx.getAttributeParameterizedTypes(objClass, this.getName());
            }
            if (attributeParameterizedTypes == null && typeName != null) {
                attributeParameterizedType = SqlUtils.getStandardModeResultClass(typeName);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("<<<  setQueryResultMapping, fullName=" + this.getFullName() + ", dbName=" + this.dbName + ", attributeType=" + String.valueOf(attributeType));
        }
        if (!exit) {
            this.sqlType.getMetaType(ctx).addScalar(ctx.getTypeFactory(), query, this.dbName, SqlUtils.getAllAttributeTypes(attributeType, attributeParameterizedTypes, attributeParameterizedType));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setQueryResultData(SqlProcessContext ctx, Object resultInstance, int resultIndex, Object[] resultValues, Map<String, Object> ids, Map<String, Object> idsProcessed, Map<String, SqlMappingIdentity> identities, Map<String, Class<?>> moreResultClasses) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setQueryResultData, fullName=" + this.getFullName() + ", resultInstance=" + String.valueOf(resultInstance) + ", resultValue=" + String.valueOf(resultValues[resultIndex]));
        }
        if (resultValues[resultIndex] == null) {
            return;
        }
        if (ids != null) {
            String idsKey = SqlUtils.getIdsKey(resultValues, identities, this.getFullName());
            boolean alreadyProcessed = ids.containsKey(idsKey);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("=== setQueryResultData, fullName=" + this.getFullName() + ", idsKey=" + idsKey + ", alreadyProcessed=" + alreadyProcessed);
            }
            if (alreadyProcessed) {
                return;
            }
        }
        boolean exit = false;
        Object obj = resultInstance;
        int count = this.attributes.size();
        for (int i = 0; i < count - 1 && !exit; ++i) {
            BeanUtilsPlugin.GetterType rt;
            SqlMappingAttribute attr = this.attributes.get(i);
            String name = attr.getName();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("=== setQueryResultData, fullName=" + this.getFullName() + ", name=" + name + ", identities=" + String.valueOf(identities.get(attr.getFullName())));
            }
            if ((rt = ctx.getGetterType(obj, name)) != null) {
                Object nextObj = ctx.invokeMethod(obj, rt.methodName, null);
                if (nextObj == null) {
                    Class<?> clazz;
                    String typeName = this.values.get(attr.getFullName() + "type");
                    Class<?> clazz2 = clazz = typeName != null ? moreResultClasses.get(typeName) : null;
                    if (clazz == null) {
                        Class<?> clazz3 = rt.type;
                        if (clazz3.isInterface()) {
                            if (clazz3 == List.class) {
                                Class<ArrayList> clazz4 = ArrayList.class;
                            } else if (clazz3 == Set.class) {
                                Class<HashSet> clazz5 = HashSet.class;
                            } else {
                                if (!ctx.isFeature(SqlFeature.IGNORE_INPROPER_OUT)) throw new SqlRuntimeException("There's no type defined for collection " + String.valueOf(clazz3) + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
                                this.logger.error("There's no type defined for collection " + String.valueOf(clazz3) + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
                                exit = true;
                            }
                        } else {
                            Class<?> clazz6 = clazz3;
                        }
                    }
                    if (!exit) {
                        void var18_25;
                        String typeName2;
                        Class<?> typeClass2 = null;
                        if (moreResultClasses != null && (typeName2 = this.values.get(attr.getFullName() + "gtype")) != null) {
                            typeClass2 = typeName2.toLowerCase().startsWith("discr") ? moreResultClasses.get(resultValues[resultIndex]) : moreResultClasses.get(typeName2);
                        }
                        if ((nextObj = typeClass2 != null && var18_25.isAssignableFrom(typeClass2) ? ctx.getInstance(typeClass2) : ctx.getInstance((Class<?>)var18_25)) != null) {
                            ctx.setAttribute(obj, name, nextObj);
                        } else {
                            if (!ctx.isFeature(SqlFeature.IGNORE_INPROPER_OUT)) throw new SqlRuntimeException("There's problem to instantiate " + String.valueOf(var18_25) + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
                            this.logger.error("There's problem to instantiate " + String.valueOf(var18_25) + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
                            exit = true;
                        }
                    }
                }
                if (!exit && nextObj instanceof Collection) {
                    String idsKey = SqlUtils.getIdsKey(resultValues, identities, attr.getFullName());
                    if (ids.containsKey(idsKey)) {
                        nextObj = ids.get(idsKey);
                    } else if (idsProcessed.containsKey(idsKey)) {
                        nextObj = idsProcessed.get(idsKey);
                    } else {
                        String string = moreResultClasses != null ? this.values.get(attr.getFullName() + "gtype") : null;
                        Class<?> typeClass = null;
                        if (string != null) {
                            typeClass = string.toLowerCase().startsWith("discr") ? moreResultClasses.get(resultValues[resultIndex]) : moreResultClasses.get(string);
                        }
                        if (typeClass == null) {
                            typeClass = rt.typeClass;
                        }
                        if (typeClass != null) {
                            Object itemObj = ctx.getInstance(typeClass);
                            if (itemObj != null) {
                                boolean nullIdentity;
                                List<Integer> idents = identities.get(attr.getFullName()) != null ? identities.get((Object)attr.getFullName()).identityIndexes : null;
                                boolean bl = nullIdentity = idents != null && !idents.isEmpty();
                                if (nullIdentity) {
                                    for (Integer id : idents) {
                                        if (resultValues[id] == null) continue;
                                        nullIdentity = false;
                                        break;
                                    }
                                }
                                if (nullIdentity) {
                                    this.logger.warn("There's null idenity " + String.valueOf(typeClass) + ", complete attribute name is " + attr.getFullName() + ", possible type name is " + string);
                                } else {
                                    ((Collection)nextObj).add(itemObj);
                                }
                                idsProcessed.put(idsKey, itemObj);
                                nextObj = itemObj;
                            } else {
                                if (!ctx.isFeature(SqlFeature.IGNORE_INPROPER_OUT)) throw new SqlRuntimeException("There's problem to instantiate " + String.valueOf(typeClass) + ", complete attribute name is " + attr.getFullName() + ", possible type name is " + string);
                                this.logger.error("There's problem to instantiate " + String.valueOf(typeClass) + ", complete attribute name is " + attr.getFullName() + ", possible type name is " + string);
                                exit = true;
                            }
                        } else {
                            if (!ctx.isFeature(SqlFeature.IGNORE_INPROPER_OUT)) throw new SqlRuntimeException("There's no generic type defined for collection " + String.valueOf(nextObj) + ", complete attribute name is " + attr.getFullName() + ", possible type name is " + string);
                            this.logger.error("There's no generic type defined for collection " + String.valueOf(nextObj) + ", complete attribute name is " + attr.getFullName() + ", possible type name is " + string);
                            exit = true;
                        }
                    }
                }
                obj = nextObj;
                continue;
            }
            if (!ctx.isFeature(SqlFeature.IGNORE_INPROPER_OUT)) throw new SqlRuntimeException("There's no getter for " + name + " in " + String.valueOf(obj) + ", complete attribute name is " + attr.getFullName());
            this.logger.error("There's no getter for " + name + " in " + String.valueOf(obj) + ", complete attribute name is " + attr.getFullName());
            exit = true;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("<<< setQueryResultData, fullName=" + this.getFullName() + ", name=" + this.getName() + ", obj=" + String.valueOf(obj) + ", resultValue=" + String.valueOf(resultValues[resultIndex]));
        }
        this.sqlType.setResult(ctx, obj, this.getName(), resultValues[resultIndex]);
    }

    SqlMappingItem merge(SqlMappingItem outputMapping) {
        SqlMappingItem resultMappingItem = new SqlMappingItem(this.dbName);
        if (this.attributes != null && this.attributes.size() > 0) {
            resultMappingItem.setAttributes(this.attributes);
            resultMappingItem.setAttributesMap(this.attributesMap);
            resultMappingItem.fullName = this.fullName;
            resultMappingItem.identity = this.identity;
            resultMappingItem.values = this.values;
        } else {
            resultMappingItem.setAttributes(outputMapping.getAttributes());
            resultMappingItem.setAttributesMap(this.attributesMap);
            resultMappingItem.fullName = outputMapping.fullName;
            resultMappingItem.identity = outputMapping.identity;
            resultMappingItem.values = outputMapping.values;
        }
        if (this.sqlType != null) {
            resultMappingItem.setSqlType(this.sqlType);
        } else {
            resultMappingItem.setSqlType(outputMapping.getSqlType());
        }
        return resultMappingItem;
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        SqlProcessResult result = new SqlProcessResult(ctx, this.dbName);
        result.addOutputValue(this.dbName, this);
        return result;
    }

    public String toString() {
        return "SqlMappingItem [attributes=" + String.valueOf(this.attributes) + ", dbName=" + this.dbName + ", fullName=" + String.valueOf(this.fullName) + ", sqlType=" + String.valueOf(this.sqlType) + ", identity=" + this.identity + "]";
    }

    static {
        CONTAINER_TYPES.add("SET");
        CONTAINER_TYPES.add("MAP");
        CONTAINER_TYPES.add("LIST");
    }
}

