/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jmx;

import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.sqlproc.engine.SqlCrudEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlEngineFactory;
import org.sqlproc.engine.SqlProcedureEngine;
import org.sqlproc.engine.SqlQueryEngine;
import org.sqlproc.engine.config.SqlEngineConfiguration;

public class SqlDefaultFactoryMXBean {
    private SqlEngineFactory sqlEngineFactory;

    public int initQueryEngines(String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        if ("*".equals(names)) {
            for (String name : this.sqlEngineFactory.getQueryNames()) {
                try {
                    this.sqlEngineFactory.getCheckedQueryEngine(name);
                    ++count;
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        } else {
            for (String name : names.split(",")) {
                try {
                    this.sqlEngineFactory.getCheckedQueryEngine(name);
                    ++count;
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        }
        if (errors.length() == 0) {
            this.storeConfiguration();
            return count;
        }
        throw new RuntimeException(errors.append("/nInitialized engines: ").append(count).toString());
    }

    public int initCrudEngines(String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        if ("*".equals(names)) {
            for (String name : this.sqlEngineFactory.getCrudNames()) {
                try {
                    this.sqlEngineFactory.getCheckedCrudEngine(name);
                    ++count;
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        } else {
            for (String name : names.split(",")) {
                try {
                    this.sqlEngineFactory.getCheckedCrudEngine(name);
                    ++count;
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        }
        if (errors.length() == 0) {
            this.storeConfiguration();
            return count;
        }
        throw new RuntimeException(errors.append("/nInitialized engines: ").append(count).toString());
    }

    public int initProcedureEngines(String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        if ("*".equals(names)) {
            for (String name : this.sqlEngineFactory.getProcedureNames()) {
                try {
                    this.sqlEngineFactory.getCheckedProcedureEngine(name);
                    ++count;
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        } else {
            for (String name : names.split(",")) {
                try {
                    this.sqlEngineFactory.getCheckedProcedureEngine(name);
                    ++count;
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        }
        if (errors.length() == 0) {
            this.storeConfiguration();
            return count;
        }
        throw new RuntimeException(errors.append("/nInitialized engines: ").append(count).toString());
    }

    public int resetQueryEngines(String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        for (String name : names.split(",")) {
            try {
                this.sqlEngineFactory.getCheckedStaticQueryEngine(name);
                ++count;
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        }
        if (errors.length() == 0) {
            this.storeConfiguration();
            return count;
        }
        throw new RuntimeException(errors.append("/nReset engines: ").append(count).toString());
    }

    public int resetCrudEngines(String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        for (String name : names.split(",")) {
            try {
                this.sqlEngineFactory.getCheckedStaticCrudEngine(name);
                ++count;
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        }
        if (errors.length() == 0) {
            this.storeConfiguration();
            return count;
        }
        throw new RuntimeException(errors.append("/nReset engines: ").append(count).toString());
    }

    public int resetProcedureEngines(String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        for (String name : names.split(",")) {
            try {
                this.sqlEngineFactory.getCheckedStaticProcedureEngine(name);
                ++count;
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        }
        if (errors.length() == 0) {
            this.storeConfiguration();
            return count;
        }
        throw new RuntimeException(errors.append("/nReset engines: ").append(count).toString());
    }

    public void newQueryEngine(String name, String sqlStatement) throws SqlEngineException {
        try {
            this.sqlEngineFactory.getDynamicQueryEngine(name, sqlStatement);
            this.storeConfiguration();
        }
        catch (SqlEngineException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void newCrudEngine(String name, String sqlStatement) {
        try {
            this.sqlEngineFactory.getDynamicCrudEngine(name, sqlStatement);
            this.storeConfiguration();
        }
        catch (SqlEngineException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void newProcedureEngine(String name, String sqlStatement) {
        try {
            this.sqlEngineFactory.getDynamicProcedureEngine(name, sqlStatement);
            this.storeConfiguration();
        }
        catch (SqlEngineException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public List<String> getQueryNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.sqlEngineFactory.getQueryNames());
        Collections.sort(list);
        return list;
    }

    public List<String> getQueryDynamicNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.sqlEngineFactory.getQueryDynamicNames());
        Collections.sort(list);
        return list;
    }

    public List<String> getCrudNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.sqlEngineFactory.getCrudNames());
        Collections.sort(list);
        return list;
    }

    public List<String> getCrudDynamicNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.sqlEngineFactory.getCrudDynamicNames());
        Collections.sort(list);
        return list;
    }

    public List<String> getProcedureNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.sqlEngineFactory.getProcedureNames());
        Collections.sort(list);
        return list;
    }

    public List<String> getProcedureDynamicNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.sqlEngineFactory.getProcedureDynamicNames());
        Collections.sort(list);
        return list;
    }

    public List<String> getQueryEngineProcessingCache(String name) {
        StringBuilder errors = new StringBuilder();
        try {
            SqlQueryEngine engine = this.sqlEngineFactory.getCheckedQueryEngine(name);
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(engine.getProcessingCache().keySet());
            Collections.sort(list);
            return list;
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
            throw new RuntimeException(errors.toString());
        }
    }

    public List<String> getCrudEngineProcessingCache(String name) {
        StringBuilder errors = new StringBuilder();
        try {
            SqlCrudEngine engine = this.sqlEngineFactory.getCheckedCrudEngine(name);
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(engine.getProcessingCache().keySet());
            Collections.sort(list);
            return list;
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
            throw new RuntimeException(errors.toString());
        }
    }

    public List<String> getProcedureEngineProcessingCache(String name) {
        StringBuilder errors = new StringBuilder();
        try {
            SqlProcedureEngine engine = this.sqlEngineFactory.getCheckedProcedureEngine(name);
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(engine.getProcessingCache().keySet());
            Collections.sort(list);
            return list;
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
            throw new RuntimeException(errors.toString());
        }
    }

    public List<String> getQueryEngineProcessingCacheStatistics(String name) {
        StringBuilder errors = new StringBuilder();
        try {
            SqlQueryEngine engine = this.sqlEngineFactory.getCheckedQueryEngine(name);
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry<String, AtomicLong> e : engine.getProcessingCacheStatistics().entrySet()) {
                list.add(e.getKey() + "=" + e.getValue().get());
            }
            Collections.sort(list);
            return list;
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
            throw new RuntimeException(errors.toString());
        }
    }

    public List<String> getCrudEngineProcessingCacheStatistics(String name) {
        StringBuilder errors = new StringBuilder();
        try {
            SqlCrudEngine engine = this.sqlEngineFactory.getCheckedCrudEngine(name);
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry<String, AtomicLong> e : engine.getProcessingCacheStatistics().entrySet()) {
                list.add(e.getKey() + "=" + e.getValue().get());
            }
            Collections.sort(list);
            return list;
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
            throw new RuntimeException(errors.toString());
        }
    }

    public List<String> getProcedureEngineProcessingCacheStatistics(String name) {
        StringBuilder errors = new StringBuilder();
        try {
            SqlProcedureEngine engine = this.sqlEngineFactory.getCheckedProcedureEngine(name);
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry<String, AtomicLong> e : engine.getProcessingCacheStatistics().entrySet()) {
                list.add(e.getKey() + "=" + e.getValue().get());
            }
            Collections.sort(list);
            return list;
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
            throw new RuntimeException(errors.toString());
        }
    }

    public int resetQueryEngineProcessingCache(String name, String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        try {
            SqlQueryEngine engine = this.sqlEngineFactory.getCheckedQueryEngine(name);
            for (String name0 : names.split(",")) {
                engine.getProcessingCache().remove(name0);
                engine.getProcessingCacheStatistics().remove(name0);
                ++count;
            }
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
        }
        if (errors.length() == 0) {
            return count;
        }
        throw new RuntimeException(errors.append("/nReset engine cache: ").append(count).toString());
    }

    public int resetCrudEngineProcessingCache(String name, String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        try {
            SqlCrudEngine engine = this.sqlEngineFactory.getCheckedCrudEngine(name);
            for (String name0 : names.split(",")) {
                engine.getProcessingCache().remove(name0);
                engine.getProcessingCacheStatistics().remove(name0);
                ++count;
            }
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
        }
        if (errors.length() == 0) {
            return count;
        }
        throw new RuntimeException(errors.append("/nReset engine cache: ").append(count).toString());
    }

    public int resetProcedureEngineProcessingCache(String name, String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        try {
            SqlProcedureEngine engine = this.sqlEngineFactory.getCheckedProcedureEngine(name);
            for (String name0 : names.split(",")) {
                engine.getProcessingCache().remove(name0);
                engine.getProcessingCacheStatistics().remove(name0);
                ++count;
            }
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
        }
        if (errors.length() == 0) {
            return count;
        }
        throw new RuntimeException(errors.append("/nReset engine cache: ").append(count).toString());
    }

    private SqlEngineConfiguration getConfiguration() {
        SqlEngineConfiguration configuration = this.sqlEngineFactory.getConfiguration();
        if (configuration == null) {
            throw new IllegalArgumentException("The dynamic configation is null");
        }
        return configuration;
    }

    public boolean isLazyInit() {
        return this.sqlEngineFactory.isLazyInit();
    }

    public void setLazyInit(boolean lazyInit) {
        this.getConfiguration().setLazyInit(lazyInit);
        this.storeConfiguration();
    }

    public Integer getAsyncInitThreads() {
        return this.getConfiguration().getAsyncInitThreads();
    }

    public void setAsyncInitThreads(Integer asyncInitThreads) {
        this.getConfiguration().setAsyncInitThreads(asyncInitThreads);
        this.storeConfiguration();
    }

    public Integer getInitTreshold() {
        return this.getConfiguration().getInitTreshold();
    }

    public void setInitTreshold(Integer initTreshold) {
        this.getConfiguration().setInitTreshold(initTreshold);
        this.storeConfiguration();
    }

    public Boolean getInitInUsageOrder() {
        return this.getConfiguration().getInitInUsageOrder();
    }

    public void setInitInUsageOrder(Boolean initInUsageOrder) {
        this.getConfiguration().setInitInUsageOrder(initInUsageOrder);
        this.storeConfiguration();
    }

    public Boolean isAsyncInitFinished() {
        return this.sqlEngineFactory.isAsyncInitFinished();
    }

    public String getEnginesInitErrors() {
        return this.sqlEngineFactory.getEnginesInitErrorsMsg();
    }

    public void loadConfiguration() {
        try {
            this.getConfiguration().load();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void storeConfiguration() {
        this.getConfiguration().store();
    }

    public void clearConfiguration() {
        this.getConfiguration().clear();
    }

    public void clearConfigurationUsage() {
        this.getConfiguration().clearUsage();
    }

    private List<String> toList(Map<String, Integer> map) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Integer> e : map.entrySet()) {
            list.add(e.getKey() + ":" + String.valueOf(e.getValue()));
        }
        return list;
    }

    public List<String> getQueryEnginesToInit() {
        return this.toList(this.getConfiguration().getQueryEnginesToInit(this.getConfiguration().getInitTreshold()));
    }

    public List<String> getCrudEnginesToInit() {
        return this.toList(this.getConfiguration().getCrudEnginesToInit(this.getConfiguration().getInitTreshold()));
    }

    public List<String> getProcedureEnginesToInit() {
        return this.toList(this.getConfiguration().getProcedureEnginesToInit(this.getConfiguration().getInitTreshold()));
    }

    public int getQueryEngineUsage(String name) {
        AtomicInteger usage = this.getConfiguration().getQueryEngines().get(name);
        if (usage == null) {
            return 0;
        }
        return usage.get();
    }

    public int getCrudEngineUsage(String name) {
        AtomicInteger usage = this.getConfiguration().getCrudEngines().get(name);
        if (usage == null) {
            return 0;
        }
        return usage.get();
    }

    public int getProcedureEngineUsage(String name) {
        AtomicInteger usage = this.getConfiguration().getProcedureEngines().get(name);
        if (usage == null) {
            return 0;
        }
        return usage.get();
    }

    public int resetQueryEngineUsage(String name) {
        AtomicInteger usage = this.getConfiguration().getQueryEngines().get(name);
        if (usage == null) {
            return 0;
        }
        usage.set(0);
        this.storeConfiguration();
        return usage.get();
    }

    public int resetCrudEngineUsage(String name) {
        AtomicInteger usage = this.getConfiguration().getCrudEngines().get(name);
        if (usage == null) {
            return 0;
        }
        usage.set(0);
        this.storeConfiguration();
        return usage.get();
    }

    public int resetProcedureEngineUsage(String name) {
        AtomicInteger usage = this.getConfiguration().getProcedureEngines().get(name);
        if (usage == null) {
            return 0;
        }
        usage.set(0);
        this.storeConfiguration();
        return usage.get();
    }

    public Boolean getUseProcessingCache() {
        return this.getConfiguration().getUseProcessingCache();
    }

    public void setUseProcessingCache(Boolean useProcessingCache) {
        this.getConfiguration().setUseProcessingCache(useProcessingCache);
        this.storeConfiguration();
    }

    public Boolean getUseDynamicProcessingCache() {
        return this.getConfiguration().getUseDynamicProcessingCache();
    }

    public void setUseDynamicProcessingCache(Boolean useDynamicProcessingCache) {
        this.getConfiguration().setUseDynamicProcessingCache(useDynamicProcessingCache);
        this.storeConfiguration();
    }

    public List<String> getDoProcessingCacheEngines() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getConfiguration().getDoProcessingCacheEngines());
        return list;
    }

    public int initDoProcessingCache(String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        for (String name : names.split(",")) {
            try {
                this.getConfiguration().getDoProcessingCacheEngines().add(name);
                ++count;
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        }
        if (errors.length() == 0) {
            this.storeConfiguration();
            return count;
        }
        throw new RuntimeException(errors.append("/nEngines for processing cache: ").append(count).toString());
    }

    public int resetDoProcessingCache(String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        if ("*".equals(names)) {
            try {
                count = this.getConfiguration().getDoProcessingCacheEngines().size();
                this.getConfiguration().getDoProcessingCacheEngines().clear();
                ++count;
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        } else {
            for (String name : names.split(",")) {
                try {
                    this.getConfiguration().getDoProcessingCacheEngines().remove(name);
                    ++count;
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        }
        if (errors.length() == 0) {
            this.storeConfiguration();
            return count;
        }
        throw new RuntimeException(errors.append("/nRemoved engines from processing cache: ").append(count).toString());
    }

    public List<String> getDontProcessingCacheEngines() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getConfiguration().getDontProcessingCacheEngines());
        return list;
    }

    public int initDontProcessingCache(String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        for (String name : names.split(",")) {
            try {
                this.getConfiguration().getDontProcessingCacheEngines().add(name);
                ++count;
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        }
        if (errors.length() == 0) {
            this.storeConfiguration();
            return count;
        }
        throw new RuntimeException(errors.append("/nEngines not for processing cache: ").append(count).toString());
    }

    public int resetDontProcessingCache(String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        if ("*".equals(names)) {
            try {
                count = this.getConfiguration().getDontProcessingCacheEngines().size();
                this.getConfiguration().getDoProcessingCacheEngines().clear();
                ++count;
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        } else {
            for (String name : names.split(",")) {
                try {
                    this.getConfiguration().getDontProcessingCacheEngines().remove(name);
                    ++count;
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        }
        if (errors.length() == 0) {
            this.storeConfiguration();
            return count;
        }
        throw new RuntimeException(errors.append("/nReset engines for processing cache: ").append(count).toString());
    }

    public void setSqlEngineFactory(SqlEngineFactory sqlEngineFactory) {
        this.sqlEngineFactory = sqlEngineFactory;
    }
}

