/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.external.apache.http.impl.io;

import java.io.IOException;
import org.testobject.external.apache.http.HttpException;
import org.testobject.external.apache.http.HttpResponse;
import org.testobject.external.apache.http.HttpResponseFactory;
import org.testobject.external.apache.http.NoHttpResponseException;
import org.testobject.external.apache.http.ParseException;
import org.testobject.external.apache.http.StatusLine;
import org.testobject.external.apache.http.annotation.NotThreadSafe;
import org.testobject.external.apache.http.config.MessageConstraints;
import org.testobject.external.apache.http.impl.DefaultHttpResponseFactory;
import org.testobject.external.apache.http.impl.io.AbstractMessageParser;
import org.testobject.external.apache.http.io.SessionInputBuffer;
import org.testobject.external.apache.http.message.LineParser;
import org.testobject.external.apache.http.message.ParserCursor;
import org.testobject.external.apache.http.params.HttpParams;
import org.testobject.external.apache.http.util.Args;
import org.testobject.external.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.responseFactory = Args.notNull(responseFactory, "Response factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

