/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.external.apache.http.impl.pool;

import java.util.concurrent.atomic.AtomicLong;
import org.testobject.external.apache.http.HttpClientConnection;
import org.testobject.external.apache.http.HttpHost;
import org.testobject.external.apache.http.annotation.ThreadSafe;
import org.testobject.external.apache.http.config.ConnectionConfig;
import org.testobject.external.apache.http.config.SocketConfig;
import org.testobject.external.apache.http.impl.pool.BasicConnFactory;
import org.testobject.external.apache.http.impl.pool.BasicPoolEntry;
import org.testobject.external.apache.http.params.HttpParams;
import org.testobject.external.apache.http.pool.AbstractConnPool;
import org.testobject.external.apache.http.pool.ConnFactory;

@ThreadSafe
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }

    @Override
    protected boolean validate(BasicPoolEntry entry) {
        return !((HttpClientConnection)entry.getConnection()).isStale();
    }
}

