/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.rest.api;

import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.testobject.rest.api.model.DeviceDescriptor;
import org.testobject.rest.api.resource.DeviceDescriptorsResource;

public class DeviceDescriptorsResourceImpl
implements DeviceDescriptorsResource {
    private final WebTarget target;

    public DeviceDescriptorsResourceImpl(WebTarget target) {
        this.target = target;
    }

    @Override
    public List<DeviceDescriptor> listDevices() {
        List<DeviceDescriptor.DeviceContainer> deviceList = this.target.path("descriptors").request("application/json").get(new GenericType<List<DeviceDescriptor.DeviceContainer>>(){});
        List<String> available = this.target.path("descriptors/availableDescriptors").request("application/json").get(new GenericType<List<String>>(){});
        LinkedList<DeviceDescriptor> devices = new LinkedList<DeviceDescriptor>();
        for (DeviceDescriptor.DeviceContainer deviceContainer : deviceList) {
            devices.add(new DeviceDescriptor(deviceContainer, available.contains(deviceContainer.id)));
        }
        return devices;
    }
}

