/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.api.v2;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import jersey.repackaged.com.google.common.base.Preconditions;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.testobject.api.v2.InvalidUserInputServerException;
import org.testobject.api.v2.TestObjectClientV2;
import org.testobject.external.apache.http.config.Registry;
import org.testobject.external.apache.http.config.RegistryBuilder;
import org.testobject.external.apache.http.conn.socket.ConnectionSocketFactory;
import org.testobject.external.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.testobject.external.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.testobject.external.apache.http.conn.ssl.X509HostnameVerifier;
import org.testobject.external.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.testobject.rest.api.model.DynamicInstrumentationRequestData;
import org.testobject.rest.api.model.InstrumentationReport;
import org.testobject.rest.api.model.StartInstrumentationResponse;
import org.testobject.rest.api.model.StaticInstrumentationRequestData;
import org.testobject.rest.api.model.TestSuiteReport;
import org.testobject.rest.api.resource.v2.AppStorageResource;
import org.testobject.rest.api.resource.v2.InstrumentationResource;
import org.testobject.rest.api.resource.v2.InstrumentationResourceImpl;
import org.testobject.rest.api.resource.v2.TestSuiteReportResourceImplV2;
import org.testobject.rest.api.resource.v2.TestSuiteReportResourceV2;
import org.testobject.rest.api.resource.v2.TestSuiteResourceImplV2;
import org.testobject.rest.api.resource.v2.TestSuiteResourceV2;
import org.testobject.rest.api.resource.v2.UploadResourceImplV2;
import org.testobject.rest.api.resource.v2.UploadResourceV2;

public class TestObjectRemoteClientV2
implements TestObjectClientV2 {
    private final UploadResourceV2 uploadV2;
    private final TestSuiteResourceV2 testSuiteV2;
    private final TestSuiteReportResourceV2 testSuiteReportV2;
    private final InstrumentationResource instrumentationResource;
    private final AppStorageResource appStorageResource;
    private final Client client;

    public TestObjectRemoteClientV2(String baseUrl, TestObjectClientV2.ProxySettings proxySettings) {
        X509HostnameVerifier defaultHostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        SslConfigurator sslConfig = SslConfigurator.newInstance();
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslConfig.createSSLContext(), new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"}, null, defaultHostnameVerifier);
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslSocketFactory)).build();
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.apache.client.connectionManager", new PoolingHttpClientConnectionManager(registry));
        ApacheConnectorProvider connector = new ApacheConnectorProvider();
        config.connectorProvider(connector);
        config.register((Class)MultiPartFeature.class);
        config.register((Class)JacksonFeature.class);
        if (proxySettings != null) {
            config.property("jersey.config.client.proxy.uri", "http://" + proxySettings.getHost() + ":" + proxySettings.getPort());
            if (proxySettings.getUsername() != null) {
                config.property("jersey.config.client.proxy.username", proxySettings.getUsername());
                config.property("jersey.config.client.proxy.password", proxySettings.getPassword());
            }
        }
        SSLContext sslContext = sslConfig.createSSLContext();
        ClientBuilder.newBuilder().sslContext(sslContext);
        this.client = ClientBuilder.newClient(config);
        WebTarget resource = this.client.target(baseUrl);
        this.uploadV2 = new UploadResourceImplV2(resource);
        this.testSuiteV2 = new TestSuiteResourceImplV2(resource);
        this.testSuiteReportV2 = new TestSuiteReportResourceImplV2(resource);
        this.instrumentationResource = new InstrumentationResourceImpl(resource);
        this.appStorageResource = new AppStorageResource(resource);
    }

    @Override
    public long uploadRunnerIpa(String apikey, File ipa) throws InvalidUserInputServerException {
        return Long.parseLong(this.appStorageResource.uploadAppXcuiTest(apikey, ipa));
    }

    @Override
    public long uploadAppIpa(String apikey, File ipa) throws InvalidUserInputServerException {
        return Long.parseLong(this.appStorageResource.uploadAppXcuiApp(apikey, ipa));
    }

    @Override
    public long uploadRunnerApk(String apikey, File apk) throws InvalidUserInputServerException {
        return Long.parseLong(this.appStorageResource.uploadAppAndroidTest(apikey, apk));
    }

    @Override
    public long uploadAppApk(String apikey, File apk) throws InvalidUserInputServerException {
        return Long.parseLong(this.appStorageResource.uploadAppAndroidApp(apikey, apk));
    }

    @Override
    public StartInstrumentationResponse startXcuiTestSuite(String apiKey, StaticInstrumentationRequestData requestData) {
        return this.instrumentationResource.createAndStartXCUITestInstrumentation(apiKey, requestData);
    }

    @Override
    public StartInstrumentationResponse startXcuiTestSuite(String apiKey, DynamicInstrumentationRequestData requestData) {
        return this.instrumentationResource.createAndStartXCUITestInstrumentation(apiKey, requestData);
    }

    @Override
    public StartInstrumentationResponse startAndroidSuite(String apiKey, StaticInstrumentationRequestData requestData) {
        return this.instrumentationResource.createAndStartAndroidInstrumentation(apiKey, requestData);
    }

    @Override
    public String readJunitReport(String apiKey, long testReportId) {
        return this.instrumentationResource.getJUnitReport(apiKey, testReportId);
    }

    @Override
    public InstrumentationReport waitForInstrumentationReport(String apiKey, long testSuiteReportId, long waitTimeoutMs, long sleepTimeMs) throws TimeoutException {
        long waitTimeoutMinutes = TimeUnit.MILLISECONDS.toMinutes(waitTimeoutMs);
        Preconditions.checkArgument(waitTimeoutMinutes <= TimeUnit.HOURS.toMinutes(2L), String.format("The timeout should be a reasonable value: no more than 120 minutes. Got %d minutes.", waitTimeoutMinutes));
        long start = this.now();
        while (this.now() - start < waitTimeoutMs) {
            InstrumentationReport testSuiteReport = this.instrumentationResource.getTestReport(apiKey, testSuiteReportId);
            if (!testSuiteReport.isRunning()) {
                return testSuiteReport;
            }
            this.sleep(sleepTimeMs);
        }
        String exceptionMessage = String.format("Unable to get a test suite report result after %d min.", waitTimeoutMinutes);
        throw new TimeoutException(exceptionMessage);
    }

    @Override
    public void updateInstrumentationTestSuite(long testSuite, File appApk, File testApk, TestSuiteResourceV2.InstrumentationTestSuiteRequest request, String apiKey) {
        String testUploadId;
        String appUploadId = this.uploadV2.uploadFile(apiKey, appApk).replace("\"", "");
        request.testUploadId = testUploadId = this.uploadV2.uploadFile(apiKey, testApk).replace("\"", "");
        request.appUploadId = appUploadId;
        this.testSuiteV2.updateInstrumentationTestSuite(testSuite, request, apiKey);
    }

    @Override
    public long startInstrumentationTestSuite(long testSuite, String apiKey) {
        return this.testSuiteV2.runInstrumentationTestSuite(testSuite, apiKey);
    }

    @Override
    public TestSuiteReport waitForSuiteReport(long testSuiteReportId, long waitTimeoutMs, long sleepTimeMs, String apiKey) {
        long start = this.now();
        while (this.now() - start < waitTimeoutMs) {
            TestSuiteReport testSuiteReport = this.testSuiteReportV2.getReport(testSuiteReportId, "application/json", apiKey);
            if (!testSuiteReport.isRunning()) {
                return testSuiteReport;
            }
            this.sleep(sleepTimeMs);
        }
        throw new IllegalStateException("unable to get test suite report result after 60min");
    }

    @Override
    public String readTestSuiteXMLReport(long testSuiteReportId, String apiKey) {
        return this.testSuiteReportV2.getXMLReport(testSuiteReportId, apiKey);
    }

    private void sleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private long now() {
        return System.currentTimeMillis();
    }

    @Override
    public void close() {
        this.client.close();
    }
}

