/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.rest.api.resource.v2;

import java.util.Base64;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.testobject.rest.api.resource.v2.TestSuiteResourceV2;

public class TestSuiteResourceImplV2
implements TestSuiteResourceV2 {
    private final WebTarget target;

    public TestSuiteResourceImplV2(WebTarget target) {
        this.target = target;
    }

    @Override
    public void updateInstrumentationTestSuite(long testSuite, TestSuiteResourceV2.InstrumentationTestSuiteRequest request, String apikey) {
        String authorizationHeaderValue = "Basic " + Base64.getEncoder().encodeToString((":" + apikey).getBytes());
        Response response = this.target.path("v2").path("batches").path("instrumentation").path(Long.toString(testSuite)).request("application/json").header("Authorization", authorizationHeaderValue).put(Entity.entity(request, "application/json"));
        if (Response.Status.NO_CONTENT.getStatusCode() != response.getStatus()) {
            throw new IllegalStateException("expected status " + Response.Status.NO_CONTENT + " but was " + response.getStatus());
        }
    }

    @Override
    public long runInstrumentationTestSuite(long testSuite, String apikey) {
        String authorizationHeaderValue = "Basic " + Base64.getEncoder().encodeToString((":" + apikey).getBytes());
        return this.target.path("v2").path("batches").path("instrumentation").path(Long.toString(testSuite)).path("replay").request("application/json").header("Authorization", authorizationHeaderValue).post(Entity.json(null), Long.class);
    }
}

