/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.rest.api.resource.v2;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Base64;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;

public class AppStorageResource {
    private final WebTarget target;

    public AppStorageResource(WebTarget target) {
        this.target = target;
    }

    public String uploadAppXcuiTest(String apiKey, File ipa) {
        return this.uploadFile(apiKey, ipa, "XCUITEST");
    }

    public String uploadAppXcuiApp(String apiKey, File ipa) {
        return this.uploadFile(apiKey, ipa, "NATIVE");
    }

    public String uploadAppAndroidTest(String apiKey, File apk) {
        return this.uploadFile(apiKey, apk, "ANDROID_INSTRUMENTATION_TEST");
    }

    public String uploadAppAndroidApp(String apiKey, File apk) {
        return this.uploadFile(apiKey, apk, "NATIVE");
    }

    private String uploadFile(String apiKey, File file, String type) {
        String authorizationHeaderValue = "Basic " + Base64.getEncoder().encodeToString(("user:" + apiKey).getBytes());
        try {
            return this.target.path("storage").path("upload").request().header("Authorization", authorizationHeaderValue).header("App-Type", type).post(Entity.entity(Files.newInputStream(file.toPath(), new OpenOption[0]), "application/octet-stream"), String.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }
}

