/*
 * Decompiled with CFR 0.152.
 */
package org.thethingsnetwork.java.app.lib;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.json.JSONObject;
import org.thethingsnetwork.java.app.lib.Message;

public class Client {
    private final String broker;
    private final String appId;
    private MqttClientPersistence persistence = new MemoryPersistence();
    private final MqttConnectOptions connOpts;
    private Consumer<MqttClient> connectHandler;
    private Consumer<Throwable> errorHandler;
    private BiConsumer<String, Message> activationHandler;
    private BiConsumer<String, Message> messageHandler;
    private MqttClient mqttClient;

    public Client(String _broker, String _appId, String _appAccessKey) throws URISyntaxException {
        this(_broker, _appId, _appAccessKey, null);
    }

    public Client(String _broker, String _appId, String _appAccessKey, MqttConnectOptions _connOpts) throws URISyntaxException {
        this.broker = this.validateBroker(_broker);
        this.appId = _appId;
        this.connOpts = _connOpts != null ? _connOpts : new MqttConnectOptions();
        this.connOpts.setUserName(_appId);
        this.connOpts.setPassword(_appAccessKey.toCharArray());
    }

    private String validateBroker(String _source) throws URISyntaxException {
        URI tempBroker = new URI(_source.contains(".") ? _source : _source + ".thethings.network");
        if ("tcp".equals(tempBroker.getScheme())) {
            if (tempBroker.getPort() == -1) {
                return tempBroker.toString() + ":1883";
            }
        } else if ("ssl".equals(tempBroker.getScheme())) {
            if (tempBroker.getPort() == -1) {
                return tempBroker.toString() + ":8883";
            }
        } else {
            return "tcp://" + tempBroker.getPath() + ":1883";
        }
        return tempBroker.toString();
    }

    public Client registerConnectHandler(Consumer<MqttClient> _handler) {
        if (this.mqttClient != null) {
            throw new RuntimeException("Can not be called while client is running");
        }
        this.connectHandler = _handler;
        return this;
    }

    public Client registerErrorHandler(Consumer<Throwable> _handler) {
        if (this.mqttClient != null) {
            throw new RuntimeException("Can not be called while client is running");
        }
        this.errorHandler = _handler;
        return this;
    }

    public Client registerActivationHandler(BiConsumer<String, Message> _handler) {
        if (this.mqttClient != null) {
            throw new RuntimeException("Can not be called while client is running");
        }
        this.activationHandler = _handler;
        return this;
    }

    public Client registerMessageHandler(BiConsumer<String, Message> _handler) {
        if (this.mqttClient != null) {
            throw new RuntimeException("Can not be called while client is running");
        }
        this.messageHandler = _handler;
        return this;
    }

    public Client setMqttPersistence(MqttClientPersistence _persistence) {
        if (this.mqttClient != null) {
            throw new RuntimeException("Can not be called while client is running");
        }
        this.persistence = _persistence;
        return this;
    }

    public Client start(String ... _topics) throws MqttException {
        if (this.mqttClient != null) {
            throw new RuntimeException("Already connected");
        }
        this.mqttClient = new MqttClient(this.broker, MqttClient.generateClientId(), this.persistence);
        this.mqttClient.connect(this.connOpts);
        this.mqttClient.setCallback(new MqttCallback(){

            public void connectionLost(Throwable cause) {
                Client.this.mqttClient = null;
                if (Client.this.errorHandler != null) {
                    Client.this.errorHandler.accept(new IOException("Connection lost", cause));
                }
            }

            public void messageArrived(String topic, MqttMessage message) throws Exception {
                String[] tokens = topic.split("\\/");
                if (tokens.length < 4) {
                    if (Client.this.errorHandler != null) {
                        Client.this.errorHandler.accept(new IllegalArgumentException("Unknown topic received: " + topic));
                    }
                    return;
                }
                block4 : switch (tokens[3]) {
                    case "up": {
                        if (Client.this.messageHandler == null) break;
                        Client.this.messageHandler.accept(tokens[2], new Message(new String(message.getPayload())));
                        break;
                    }
                    case "events": {
                        if (tokens.length <= 5) break;
                        switch (tokens[4]) {
                            case "activations": {
                                if (Client.this.activationHandler == null) break block4;
                                Client.this.activationHandler.accept(tokens[2], new Message(new String(message.getPayload())));
                                break;
                            }
                            default: {
                                if (Client.this.errorHandler == null) break block4;
                                Client.this.errorHandler.accept(new IllegalArgumentException("Unknown topic received: " + topic));
                                break;
                            }
                        }
                        break;
                    }
                    default: {
                        if (Client.this.errorHandler == null) break;
                        Client.this.errorHandler.accept(new IllegalArgumentException("Unknown topic received: " + topic));
                    }
                }
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }
        });
        if (this.connectHandler != null) {
            this.connectHandler.accept(this.mqttClient);
        }
        this.mqttClient.subscribe(_topics);
        return this;
    }

    public Client start() throws MqttException {
        return this.start("+/devices/+/activations", "+/devices/+/up");
    }

    public Client end() throws MqttException {
        if (this.mqttClient == null) {
            throw new RuntimeException("Not connected");
        }
        return this.end(5000L);
    }

    public Client end(long _timeout) throws MqttException {
        if (this.mqttClient == null) {
            throw new RuntimeException("Not connected");
        }
        this.mqttClient.disconnect(_timeout);
        if (!this.mqttClient.isConnected()) {
            this.mqttClient = null;
        }
        return this;
    }

    public Client endNow() throws MqttException {
        if (this.mqttClient == null) {
            throw new RuntimeException("Not connected");
        }
        this.mqttClient.disconnectForcibly(0L, 0L);
        this.mqttClient = null;
        return this;
    }

    public void send(String _devId, byte[] _payload, int _port) throws MqttException {
        JSONObject data = new JSONObject();
        data.put("payload_raw", (Object)Base64.getEncoder().encodeToString(_payload));
        data.put("port", _port != 0 ? _port : 1);
        this.mqttClient.publish(this.appId + "/devices/" + _devId + "/down", data.toString().getBytes(), 0, false);
    }

    public void send(String _devId, JSONObject _payload, int _port) throws MqttException {
        JSONObject data = new JSONObject();
        data.put("payload_fields", (Object)_payload);
        data.put("port", _port != 0 ? _port : 1);
        this.mqttClient.publish(this.appId + "/devices/" + _devId + "/down", data.toString().getBytes(), 0, false);
    }
}

