/*
 * Decompiled with CFR 0.152.
 */
package org.threeriverdev.donortools;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.threeriverdev.donortools.model.Donation;
import org.threeriverdev.donortools.model.Persona;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DonorToolsClient {
    private final Client client = ClientBuilder.newClient();
    private final String endpoint;
    private static XPathFactory xfactory = XPathFactory.newInstance();

    public DonorToolsClient(String endpoint, String username, String password) {
        this.endpoint = endpoint;
        HttpAuthenticationFeature authenticationFeature = HttpAuthenticationFeature.basic((String)username, (String)password);
        this.client.register((Object)authenticationFeature);
    }

    private WebTarget getTarget(String path) {
        return this.client.target(this.endpoint).path(path);
    }

    public Integer create(Persona persona) throws Exception {
        WebTarget target = this.getTarget("/people.xml");
        org.w3c.dom.Document document = DonorToolsClient.buildDocument("/persona_new.xml");
        DonorToolsClient.setValue(document, "//company-name", persona.getCompanyName());
        DonorToolsClient.setValue(document, "//first-name", persona.getNames().get(0).getFirstName());
        DonorToolsClient.setValue(document, "//last-name", persona.getNames().get(0).getLastName());
        if (persona.getEmailAddresses() != null && persona.getEmailAddresses().size() > 0) {
            DonorToolsClient.setValue(document, "//email-addresses/email-address/email-address", persona.getEmailAddresses().get(0).getEmailAddress());
        }
        if (persona.getAddresses() != null && persona.getAddresses().size() > 0) {
            DonorToolsClient.setValue(document, "//addresses/address/city", persona.getAddresses().get(0).getCity());
            DonorToolsClient.setValue(document, "//addresses/address/country", persona.getAddresses().get(0).getCountry());
            DonorToolsClient.setValue(document, "//addresses/address/postal-code", persona.getAddresses().get(0).getPostalCode());
            DonorToolsClient.setValue(document, "//addresses/address/state", persona.getAddresses().get(0).getState());
            DonorToolsClient.setValue(document, "//addresses/address/street-address", persona.getAddresses().get(0).getStreetAddress());
        }
        if (persona.getPhoneNumbers() != null && persona.getPhoneNumbers().size() > 0) {
            DonorToolsClient.setValue(document, "//phone-numbers/phone-number/phone-number", persona.getPhoneNumbers().get(0).getPhoneNumber());
            DonorToolsClient.setValue(document, "//phone-numbers/phone-number/extension", persona.getPhoneNumbers().get(0).getExtension());
        }
        Entity entity = Entity.entity((Object)DonorToolsClient.getString(document), (MediaType)MediaType.APPLICATION_XML_TYPE);
        Response resp = target.request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).post(entity);
        String result = (String)resp.readEntity(String.class);
        org.w3c.dom.Document doc = DonorToolsClient.buildDocumentFromString(result);
        return Integer.valueOf(DonorToolsClient.getValue(doc, "//id"));
    }

    public List<Persona> listPersonas() {
        ArrayList<Persona> people = new ArrayList<Persona>();
        WebTarget target = this.getTarget("/people.xml");
        Response resp = target.request(new String[]{"application/xml"}).get();
        String result = (String)resp.readEntity(String.class);
        SAXBuilder builder1 = new SAXBuilder();
        try {
            Document document = builder1.build((Reader)new StringReader(result));
            Element rootNode = document.getRootElement();
            List personas = rootNode.getChildren("persona");
            for (Object personaObj : personas) {
                Persona persona = new Persona();
                Element xmlPersona = (Element)personaObj;
                String companyName = xmlPersona.getChild("company-name").getValue();
                persona.setCompanyName(companyName);
                people.add(persona);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return people;
    }

    public Integer create(Donation donation) throws Exception {
        WebTarget target = this.getTarget("/donations.xml");
        org.w3c.dom.Document document = DonorToolsClient.buildDocument("/donation_new.xml");
        DonorToolsClient.setValue(document, "/donation/amount-in-cents", donation.getAmountInCents());
        DonorToolsClient.setValue(document, "/donation/donation-type-id", donation.getDonationTypeId());
        DonorToolsClient.setValue(document, "/donation/persona-id", donation.getPersonaId());
        DonorToolsClient.setValue(document, "/donation/source-id", donation.getSourceId());
        DonorToolsClient.setValue(document, "/donation/memo", donation.getMemo());
        DonorToolsClient.setValue(document, "//splits/split/amount-in-cents", donation.getSplits().get(0).getAmountInCents());
        DonorToolsClient.setValue(document, "//splits/split/fund-id", donation.getSplits().get(0).getFundId());
        String xml = DonorToolsClient.getString(document);
        Entity entity = Entity.entity((Object)xml, (MediaType)MediaType.APPLICATION_XML_TYPE);
        Response resp = target.request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).post(entity);
        String result = (String)resp.readEntity(String.class);
        org.w3c.dom.Document doc = DonorToolsClient.buildDocumentFromString(result);
        return Integer.valueOf(DonorToolsClient.getValue(doc, "//id"));
    }

    private static void setValue(org.w3c.dom.Document document, String xpath, Object value) {
        try {
            XPath xpathObj = xfactory.newXPath();
            Node node = (Node)xpathObj.evaluate(xpath, document, XPathConstants.NODE);
            if (value != null) {
                node.setTextContent(value.toString());
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getValue(org.w3c.dom.Document document, String xpath) {
        try {
            XPath xpathObj = xfactory.newXPath();
            Node node = (Node)xpathObj.evaluate(xpath, document, XPathConstants.NODE);
            return node.getTextContent();
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private static org.w3c.dom.Document buildDocument(String file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        return documentBuilder.parse(DonorToolsClient.class.getResourceAsStream(file));
    }

    private static org.w3c.dom.Document buildDocumentFromString(String xml) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        return documentBuilder.parse(IOUtils.toInputStream((String)xml));
    }

    private static String getString(org.w3c.dom.Document doc) throws TransformerException {
        StringWriter writer = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        return writer.getBuffer().toString().replaceAll("\n|\r", "");
    }
}

