/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api.db;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import oracle.jdbc.OracleConnection;

public class DynamicParameterList {
    private final LinkedHashMap<String, DynamicParameter> params;

    private DynamicParameterList(LinkedHashMap<String, DynamicParameter> params) {
        this.params = params;
    }

    public String getSql() {
        return this.params.entrySet().stream().map(e -> ((DynamicParameter)e.getValue()).getSql((String)e.getKey())).collect(Collectors.joining(", "));
    }

    public void setParamsStartWithIndex(CallableStatement statement, int startIndex) throws SQLException {
        int index = startIndex;
        for (DynamicParameter param : this.params.values()) {
            param.setParam(statement, index++);
        }
    }

    public static DynamicParameterListBuilder builder() {
        return new DynamicParameterListBuilder();
    }

    private static class DynamicArrayParameter
    implements DynamicParameter {
        private final Object[] value;
        private final String customTypeName;
        private final OracleConnection oraConnection;

        DynamicArrayParameter(Object[] value, String customTypeName, OracleConnection oraConnection) {
            this.value = value;
            this.customTypeName = customTypeName;
            this.oraConnection = oraConnection;
        }

        @Override
        public void setParam(CallableStatement statement, int index) throws SQLException {
            if (this.value == null) {
                statement.setNull(index, 2003, this.customTypeName);
            } else {
                statement.setArray(index, this.oraConnection.createOracleArray(this.customTypeName, (Object)this.value));
            }
        }
    }

    private static class DynamicBoolParameter
    implements DynamicParameter {
        private final Boolean value;

        DynamicBoolParameter(Boolean value) {
            this.value = value;
        }

        @Override
        public void setParam(CallableStatement statement, int index) throws SQLException {
            if (this.value == null) {
                statement.setNull(index, 16);
            } else {
                statement.setInt(index, this.value != false ? 1 : 0);
            }
        }

        @Override
        public String getSql(String key) {
            return key + " => (case ? when 1 then true else false end)";
        }
    }

    private static class DynamicIntegerParameter
    implements DynamicParameter {
        private final Integer value;

        DynamicIntegerParameter(Integer value) {
            this.value = value;
        }

        @Override
        public void setParam(CallableStatement statement, int index) throws SQLException {
            if (this.value == null) {
                statement.setNull(index, 4);
            } else {
                statement.setInt(index, (int)this.value);
            }
        }
    }

    private static class DynamicStringParameter
    implements DynamicParameter {
        private final String value;

        DynamicStringParameter(String value) {
            this.value = value;
        }

        @Override
        public void setParam(CallableStatement statement, int index) throws SQLException {
            if (this.value == null) {
                statement.setNull(index, 12);
            } else {
                statement.setString(index, this.value);
            }
        }
    }

    public static class DynamicParameterListBuilder {
        private final LinkedHashMap<String, DynamicParameter> params = new LinkedHashMap();

        private DynamicParameterListBuilder() {
        }

        public DynamicParameterListBuilder add(String identifier, String value) {
            this.params.put(identifier, new DynamicStringParameter(value));
            return this;
        }

        public DynamicParameterListBuilder addIfNotEmpty(String identifier, String value) {
            if (value != null && !value.isEmpty()) {
                this.add(identifier, value);
            }
            return this;
        }

        public DynamicParameterListBuilder add(String identifier, Integer value) {
            this.params.put(identifier, new DynamicIntegerParameter(value));
            return this;
        }

        public DynamicParameterListBuilder addIfNotEmpty(String identifier, Integer value) {
            if (value != null) {
                this.add(identifier, value);
            }
            return this;
        }

        public DynamicParameterListBuilder add(String identifier, Object[] value, String customTypeName, OracleConnection oraConnection) {
            this.params.put(identifier, new DynamicArrayParameter(value, customTypeName, oraConnection));
            return this;
        }

        public DynamicParameterListBuilder addIfNotEmpty(String identifier, Object[] value, String customTypeName, OracleConnection oraConnection) {
            if (value != null && value.length > 0) {
                this.add(identifier, value, customTypeName, oraConnection);
            }
            return this;
        }

        public DynamicParameterListBuilder add(String identifier, Boolean value) {
            this.params.put(identifier, new DynamicBoolParameter(value));
            return this;
        }

        public DynamicParameterListBuilder addIfNotEmpty(String identifier, Boolean value) {
            if (value != null) {
                this.add(identifier, value);
            }
            return this;
        }

        public DynamicParameterList build() {
            return new DynamicParameterList(this.params);
        }
    }

    static interface DynamicParameter {
        public void setParam(CallableStatement var1, int var2) throws SQLException;

        default public String getSql(String key) {
            return key + " => ?";
        }
    }
}

