/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api.reporter;

import java.sql.SQLException;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import oracle.sql.Datum;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import org.utplsql.api.compatibility.CompatibilityProxy;
import org.utplsql.api.reporter.DefaultReporter;
import org.utplsql.api.reporter.DefaultReporterFactoryMethodRegistrator;
import org.utplsql.api.reporter.Reporter;

public final class ReporterFactory
implements ORADataFactory {
    private final Map<String, ReporterFactoryMethodInfo> reportFactoryMethodMap = new HashMap<String, ReporterFactoryMethodInfo>();

    ReporterFactory() {
    }

    public static ReporterFactory createEmpty() {
        return new ReporterFactory();
    }

    public static ReporterFactory createDefault(CompatibilityProxy proxy) {
        ReporterFactory reporterFactory = new ReporterFactory();
        DefaultReporterFactoryMethodRegistrator.registerDefaultReporters(reporterFactory, proxy);
        return reporterFactory;
    }

    public synchronized ReporterFactoryMethodInfo registerReporterFactoryMethod(String reporterName, BiFunction<String, Object[], ? extends Reporter> factoryMethod, String description) {
        return this.reportFactoryMethodMap.put(reporterName.toUpperCase(), new ReporterFactoryMethodInfo(factoryMethod, description));
    }

    public synchronized ReporterFactoryMethodInfo unregisterReporterFactoryMethod(String reporterName) {
        return this.reportFactoryMethodMap.remove(reporterName.toUpperCase());
    }

    public synchronized boolean hasRegisteredFactoryMethodFor(String reporterName) {
        return this.reportFactoryMethodMap.containsKey(reporterName.toUpperCase());
    }

    public Reporter createReporter(String reporterName, @Nullable Object[] attributes) {
        reporterName = reporterName.toUpperCase();
        BiFunction<String, Object[], Reporter> supplier = DefaultReporter::new;
        if (this.reportFactoryMethodMap.containsKey(reporterName)) {
            ReporterFactoryMethodInfo ri = this.reportFactoryMethodMap.get(reporterName);
            if (ri == null) {
                throw new RuntimeException("ReporterFactoryMethodInfo for " + reporterName + " was null");
            }
            supplier = ri.factoryMethod;
        }
        if (supplier == null) {
            throw new RuntimeException("No factory method for " + reporterName);
        }
        return supplier.apply(reporterName, attributes);
    }

    public Reporter createReporter(String reporterName) {
        return this.createReporter(reporterName, null);
    }

    public Map<String, String> getRegisteredReporterInfo() {
        HashMap<String, String> descMap = new HashMap<String, String>(this.reportFactoryMethodMap.size());
        for (Map.Entry<String, ReporterFactoryMethodInfo> entry : this.reportFactoryMethodMap.entrySet()) {
            descMap.put(entry.getKey(), entry.getValue().description);
        }
        return descMap;
    }

    public ORAData create(Datum d, int sqlType) throws SQLException {
        if (d == null) {
            return null;
        }
        if (d instanceof Struct) {
            String sqlName = ((Struct)d).getSQLTypeName();
            return this.createReporter(sqlName, ((Struct)d).getAttributes());
        }
        return null;
    }

    public static class ReporterFactoryMethodInfo {
        public final BiFunction<String, Object[], ? extends Reporter> factoryMethod;
        public final String description;

        public ReporterFactoryMethodInfo(BiFunction<String, Object[], ? extends Reporter> factoryMethod, String description) {
            this.factoryMethod = factoryMethod;
            this.description = description;
        }
    }
}

