/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dom;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.jdesktop.dom.SimpleDocumentBuilder;
import org.jdesktop.dom.SimpleNodeList;
import org.jdesktop.xpath.XPathUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class SimpleDocument
implements Document {
    private Document dom;
    private XPath xpath;
    private Map<String, SoftReference<XPathExpression>> cachedExpressions = new HashMap<String, SoftReference<XPathExpression>>();

    public SimpleDocument() {
        this(new SimpleDocumentBuilder().newPlainDocument());
    }

    public SimpleDocument(Document document) {
        if (document == null) {
            throw new NullPointerException("DOM Cannot be null");
        }
        this.dom = document;
    }

    public SimpleDocument(String string) {
        try {
            this.dom = SimpleDocumentBuilder.simpleParse(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String toString() {
        return this.toXML();
    }

    public String toXML() {
        return XPathUtils.toXML(this.dom);
    }

    public String toXML(Node node) {
        SimpleDocument simpleDocument = new SimpleDocument();
        Node node2 = node.cloneNode(true);
        simpleDocument.adoptNode(node2);
        simpleDocument.appendChild(node2);
        return simpleDocument.toXML();
    }

    public SimpleNodeList getChildElements(Node node) {
        Node[] nodeArray = new Node[this.getChildElementCount(node)];
        int n = 0;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            nodeArray[n++] = node2;
        }
        return new SimpleNodeList(nodeArray);
    }

    public int getChildElementCount(Node node) {
        int n = 0;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            ++n;
        }
        return n;
    }

    private XPathExpression compile(String string) throws XPathExpressionException {
        XPathExpression xPathExpression;
        SoftReference<XPathExpression> softReference = this.cachedExpressions.get(string);
        XPathExpression xPathExpression2 = xPathExpression = softReference == null ? null : softReference.get();
        if (xPathExpression == null) {
            this.cachedExpressions.remove(string);
            xPathExpression = XPathUtils.compile(string);
            this.cachedExpressions.put(string, new SoftReference<XPathExpression>(xPathExpression));
        }
        return xPathExpression;
    }

    public SimpleNodeList getElements(String string) {
        try {
            return XPathUtils.getElements(this.compile(string), (Node)this.dom);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new IllegalArgumentException(xPathExpressionException);
        }
    }

    public SimpleNodeList getElements(String string, Node node) {
        try {
            return XPathUtils.getElements(this.compile(string), node);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new IllegalArgumentException(xPathExpressionException);
        }
    }

    public Node getElement(String string) {
        try {
            return XPathUtils.getElement(this.compile(string), (Node)this.dom);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new IllegalArgumentException(xPathExpressionException);
        }
    }

    public Node getElement(String string, Node node) {
        try {
            return XPathUtils.getElement(this.compile(string), node);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new IllegalArgumentException(xPathExpressionException);
        }
    }

    public String getString(String string) {
        try {
            return XPathUtils.getString(this.compile(string), (Node)this.dom);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new IllegalArgumentException(xPathExpressionException);
        }
    }

    public String getString(String string, Node node) {
        try {
            return XPathUtils.getString(this.compile(string), node);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new IllegalArgumentException(xPathExpressionException);
        }
    }

    @Override
    public DocumentType getDoctype() {
        return this.dom.getDoctype();
    }

    @Override
    public DOMImplementation getImplementation() {
        return this.dom.getImplementation();
    }

    @Override
    public Element getDocumentElement() {
        return this.dom.getDocumentElement();
    }

    @Override
    public Element createElement(String string) throws DOMException {
        return this.dom.createElement(string);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return this.dom.createDocumentFragment();
    }

    @Override
    public Text createTextNode(String string) {
        return this.dom.createTextNode(string);
    }

    @Override
    public Comment createComment(String string) {
        return this.dom.createComment(string);
    }

    @Override
    public CDATASection createCDATASection(String string) throws DOMException {
        return this.dom.createCDATASection(string);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        return this.dom.createProcessingInstruction(string, string2);
    }

    @Override
    public Attr createAttribute(String string) throws DOMException {
        return this.dom.createAttribute(string);
    }

    @Override
    public EntityReference createEntityReference(String string) throws DOMException {
        return this.dom.createEntityReference(string);
    }

    @Override
    public SimpleNodeList getElementsByTagName(String string) {
        return new SimpleNodeList(this.dom.getElementsByTagName(string));
    }

    @Override
    public Node importNode(Node node, boolean bl) throws DOMException {
        return this.dom.importNode(node, bl);
    }

    @Override
    public Element createElementNS(String string, String string2) throws DOMException {
        return this.dom.createElementNS(string, string2);
    }

    @Override
    public Attr createAttributeNS(String string, String string2) throws DOMException {
        return this.dom.createAttributeNS(string, string2);
    }

    @Override
    public SimpleNodeList getElementsByTagNameNS(String string, String string2) {
        return new SimpleNodeList(this.dom.getElementsByTagNameNS(string, string2));
    }

    @Override
    public Element getElementById(String string) {
        return this.dom.getElementById(string);
    }

    @Override
    public String getInputEncoding() {
        return this.dom.getInputEncoding();
    }

    @Override
    public String getXmlEncoding() {
        return this.dom.getXmlEncoding();
    }

    @Override
    public boolean getXmlStandalone() {
        return this.dom.getXmlStandalone();
    }

    @Override
    public void setXmlStandalone(boolean bl) throws DOMException {
        this.dom.setXmlStandalone(bl);
    }

    @Override
    public String getXmlVersion() {
        return this.dom.getXmlVersion();
    }

    @Override
    public void setXmlVersion(String string) throws DOMException {
        this.dom.setXmlVersion(string);
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.dom.getStrictErrorChecking();
    }

    @Override
    public void setStrictErrorChecking(boolean bl) {
        this.dom.setStrictErrorChecking(bl);
    }

    @Override
    public String getDocumentURI() {
        return this.dom.getDocumentURI();
    }

    @Override
    public void setDocumentURI(String string) {
        this.dom.setDocumentURI(string);
    }

    @Override
    public Node adoptNode(Node node) throws DOMException {
        return this.dom.adoptNode(node);
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this.dom.getDomConfig();
    }

    @Override
    public void normalizeDocument() {
        this.dom.normalizeDocument();
    }

    @Override
    public Node renameNode(Node node, String string, String string2) throws DOMException {
        return this.dom.renameNode(node, string, string2);
    }

    @Override
    public String getNodeName() {
        return this.dom.getNodeName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.dom.getNodeValue();
    }

    @Override
    public void setNodeValue(String string) throws DOMException {
        this.dom.setNodeValue(string);
    }

    @Override
    public short getNodeType() {
        return this.dom.getNodeType();
    }

    @Override
    public Node getParentNode() {
        return this.dom.getParentNode();
    }

    @Override
    public SimpleNodeList getChildNodes() {
        return new SimpleNodeList(this.dom.getChildNodes());
    }

    @Override
    public Node getFirstChild() {
        return this.dom.getFirstChild();
    }

    @Override
    public Node getLastChild() {
        return this.dom.getLastChild();
    }

    @Override
    public Node getPreviousSibling() {
        return this.dom.getPreviousSibling();
    }

    @Override
    public Node getNextSibling() {
        return this.dom.getNextSibling();
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.dom.getAttributes();
    }

    @Override
    public Document getOwnerDocument() {
        return this.dom.getOwnerDocument();
    }

    @Override
    public Node insertBefore(Node node, Node node2) throws DOMException {
        return this.dom.insertBefore(node, node2);
    }

    @Override
    public Node replaceChild(Node node, Node node2) throws DOMException {
        return this.dom.replaceChild(node, node2);
    }

    @Override
    public Node removeChild(Node node) throws DOMException {
        return this.dom.removeChild(node);
    }

    @Override
    public Node appendChild(Node node) throws DOMException {
        return this.dom.appendChild(node);
    }

    @Override
    public boolean hasChildNodes() {
        return this.dom.hasChildNodes();
    }

    @Override
    public Node cloneNode(boolean bl) {
        return this.dom.cloneNode(bl);
    }

    @Override
    public void normalize() {
        this.dom.normalize();
    }

    @Override
    public boolean isSupported(String string, String string2) {
        return this.dom.isSupported(string, string2);
    }

    @Override
    public String getNamespaceURI() {
        return this.dom.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.dom.getPrefix();
    }

    @Override
    public void setPrefix(String string) throws DOMException {
        this.dom.setPrefix(string);
    }

    @Override
    public String getLocalName() {
        return this.dom.getLocalName();
    }

    @Override
    public boolean hasAttributes() {
        return this.dom.hasAttributes();
    }

    @Override
    public String getBaseURI() {
        return this.dom.getBaseURI();
    }

    @Override
    public short compareDocumentPosition(Node node) throws DOMException {
        return this.dom.compareDocumentPosition(node);
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.dom.getTextContent();
    }

    @Override
    public void setTextContent(String string) throws DOMException {
        this.dom.setTextContent(string);
    }

    @Override
    public boolean isSameNode(Node node) {
        return this.dom.isSameNode(node);
    }

    @Override
    public String lookupPrefix(String string) {
        return this.dom.lookupPrefix(string);
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        return this.dom.isDefaultNamespace(string);
    }

    @Override
    public String lookupNamespaceURI(String string) {
        return this.dom.lookupNamespaceURI(string);
    }

    @Override
    public boolean isEqualNode(Node node) {
        return this.dom.isEqualNode(node);
    }

    @Override
    public Object getFeature(String string, String string2) {
        return this.dom.getFeature(string, string2);
    }

    @Override
    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        return this.dom.setUserData(string, object, userDataHandler);
    }

    @Override
    public Object getUserData(String string) {
        return this.dom.getUserData(string);
    }
}

