/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dom;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.jdesktop.dom.SimpleDocument;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimpleDocumentBuilder
extends DocumentBuilder {
    private static ThreadLocal<SimpleDocumentBuilder> PARSER = new ThreadLocal<SimpleDocumentBuilder>(){

        @Override
        protected SimpleDocumentBuilder initialValue() {
            return new SimpleDocumentBuilder(false);
        }
    };
    private static ThreadLocal<SimpleDocumentBuilder> NS_PARSER = new ThreadLocal<SimpleDocumentBuilder>(){

        @Override
        protected SimpleDocumentBuilder initialValue() {
            return new SimpleDocumentBuilder(true);
        }
    };
    private DocumentBuilder builder;

    public SimpleDocumentBuilder() {
        this(true);
    }

    public SimpleDocumentBuilder(boolean bl) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(bl);
            this.builder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException("Could not create DOM DocumentBuilder", parserConfigurationException);
        }
    }

    public SimpleDocumentBuilder(DocumentBuilderFactory documentBuilderFactory) {
        try {
            this.builder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException("Could not create DOM DocumentBuilder", parserConfigurationException);
        }
    }

    public SimpleDocument parseString(String string) throws SAXException, IOException {
        if (string == null) {
            throw new IllegalArgumentException("xml cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return this.parse(byteArrayInputStream);
    }

    @Override
    public SimpleDocument parse(InputSource inputSource) throws SAXException, IOException {
        return new SimpleDocument(this.builder.parse(inputSource));
    }

    @Override
    public SimpleDocument parse(InputStream inputStream) throws SAXException, IOException {
        return new SimpleDocument(super.parse(inputStream));
    }

    @Override
    public SimpleDocument parse(InputStream inputStream, String string) throws SAXException, IOException {
        return new SimpleDocument(super.parse(inputStream, string));
    }

    @Override
    public SimpleDocument parse(String string) throws SAXException, IOException {
        return new SimpleDocument(super.parse(string));
    }

    @Override
    public SimpleDocument parse(File file) throws SAXException, IOException {
        return new SimpleDocument(super.parse(file));
    }

    @Override
    public boolean isNamespaceAware() {
        return this.builder.isNamespaceAware();
    }

    @Override
    public boolean isValidating() {
        return this.builder.isValidating();
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.builder.setEntityResolver(entityResolver);
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.builder.setErrorHandler(errorHandler);
    }

    @Override
    public SimpleDocument newDocument() {
        return new SimpleDocument(this.builder.newDocument());
    }

    Document newPlainDocument() {
        return this.builder.newDocument();
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return this.builder.getDOMImplementation();
    }

    @Override
    public void reset() {
        this.builder.reset();
    }

    @Override
    public Schema getSchema() {
        return this.builder.getSchema();
    }

    @Override
    public boolean isXIncludeAware() {
        return this.builder.isXIncludeAware();
    }

    public static SimpleDocument simpleParse(InputSource inputSource) throws SAXException, IOException {
        return SimpleDocumentBuilder.simpleParse(inputSource, false);
    }

    public static SimpleDocument simpleParse(InputStream inputStream) throws SAXException, IOException {
        return SimpleDocumentBuilder.simpleParse(inputStream, false);
    }

    public static SimpleDocument simpleParse(URL uRL) throws SAXException, IOException {
        return SimpleDocumentBuilder.simpleParse(uRL, false);
    }

    public static SimpleDocument simpleParse(String string) throws SAXException, IOException {
        return SimpleDocumentBuilder.simpleParse(string, false);
    }

    public static SimpleDocument simpleParse(InputSource inputSource, boolean bl) throws SAXException, IOException {
        return bl ? NS_PARSER.get().parse(inputSource) : PARSER.get().parse(inputSource);
    }

    public static SimpleDocument simpleParse(InputStream inputStream, boolean bl) throws SAXException, IOException {
        return bl ? NS_PARSER.get().parse(inputStream) : PARSER.get().parse(inputStream);
    }

    public static SimpleDocument simpleParse(URL uRL, boolean bl) throws SAXException, IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        InputStream inputStream = uRL.openStream();
        return SimpleDocumentBuilder.simpleParse(inputStream, bl);
    }

    public static SimpleDocument simpleParse(String string, boolean bl) throws SAXException, IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return SimpleDocumentBuilder.simpleParse(byteArrayInputStream, bl);
    }
}

