/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dom;

import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleNodeList
implements NodeList,
Iterable<Node> {
    private NodeList list;

    public SimpleNodeList(NodeList nodeList) {
        if (nodeList == null) {
            throw new NullPointerException();
        }
        this.list = nodeList;
    }

    public SimpleNodeList(List<Node> list) {
        this(list.toArray(new Node[0]));
    }

    public SimpleNodeList(Node ... nodeArray) {
        final Node[] nodeArray2 = new Node[nodeArray == null ? 0 : nodeArray.length];
        System.arraycopy(nodeArray, 0, nodeArray2, 0, nodeArray2.length);
        this.list = new NodeList(){

            @Override
            public int getLength() {
                return nodeArray2.length;
            }

            @Override
            public Node item(int n) {
                return nodeArray2[n];
            }
        };
    }

    @Override
    public Node item(int n) {
        return this.list.item(n);
    }

    @Override
    public int getLength() {
        return this.list.getLength();
    }

    @Override
    public Iterator<Node> iterator() {
        return new Iterator<Node>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < SimpleNodeList.this.getLength();
            }

            @Override
            public Node next() {
                return SimpleNodeList.this.item(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

