/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http;

import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdesktop.http.Cookie;

public class CookieManager
extends CookieHandler {
    private static Map<String, Set<Wrapper>> cache = new HashMap<String, Set<Wrapper>>();

    private CookieManager() {
    }

    @Override
    public Map<String, List<String>> get(URI uRI, Map<String, List<String>> map) throws IOException {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (uRI == null) {
            return hashMap;
        }
        Set<Wrapper> set = cache.get(uRI.getHost());
        if (set != null) {
            for (Wrapper wrapper : set) {
                if (!CookieManager.pathsMatch(uRI.getPath(), wrapper.cookie.getPath())) continue;
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get("Cookie");
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    hashMap.put("Cookie", arrayList);
                }
                Cookie cookie = wrapper.cookie;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(cookie.getName()).append("=").append(cookie.getValue());
                arrayList.add(stringBuffer.toString());
            }
        }
        return hashMap;
    }

    @Override
    public void put(URI uRI, Map<String, List<String>> map) throws IOException {
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (!"Set-Cookie".equalsIgnoreCase(entry.getKey())) continue;
            Set<Wrapper> set = cache.get(uRI.getHost());
            if (set == null) {
                set = new HashSet<Wrapper>();
                cache.put(uRI.getHost(), set);
            }
            for (String string : entry.getValue()) {
                Cookie cookie = Cookie.parseCookie(string);
                Wrapper wrapper = new Wrapper(cookie);
                if (cookie.getMaxAge() == 0) {
                    set.remove(wrapper);
                    continue;
                }
                set.add(wrapper);
            }
        }
    }

    public static Cookie[] getCookies(URI uRI) {
        return CookieManager.getCookies(uRI.getHost());
    }

    public static Cookie[] getCookies(String string) {
        Set<Wrapper> set = cache.get(string);
        if (set == null) {
            return new Cookie[0];
        }
        Cookie[] cookieArray = new Cookie[set.size()];
        int n = 0;
        for (Wrapper wrapper : set) {
            cookieArray[n++] = wrapper.cookie;
        }
        return cookieArray;
    }

    public static Cookie[] getCookies() {
        HashSet<Cookie> hashSet = new HashSet<Cookie>();
        for (Map.Entry<String, Set<Wrapper>> entry : cache.entrySet()) {
            if (entry.getValue() == null) continue;
            for (Wrapper wrapper : entry.getValue()) {
                hashSet.add(wrapper.cookie);
            }
        }
        return hashSet.toArray(new Cookie[0]);
    }

    private static boolean pathsMatch(String string, String string2) {
        if (string == null && string2 != null || string2 == null && string != null) {
            return false;
        }
        if (string == null && string2 == null) {
            return true;
        }
        return string.equals(string2) || string.startsWith(string2);
    }

    public static void install() {
        CookieHandler.setDefault(new CookieManager());
    }

    private static final class Wrapper {
        private Cookie cookie;

        private Wrapper(Cookie cookie) {
            if (cookie == null) {
                throw new NullPointerException();
            }
            this.cookie = cookie;
        }

        public boolean equals(Object object) {
            if (object instanceof Wrapper) {
                return this.cookie.getName().equalsIgnoreCase(((Wrapper)object).cookie.getName());
            }
            return false;
        }

        public Cookie unwrap() {
            return this.cookie;
        }

        public void eat() {
        }

        public boolean wasTasty() {
            return true;
        }
    }
}

