/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.jdesktop.http.SecurityHandler;

class MediumSecurityX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private static final Logger LOG = Logger.getLogger(MediumSecurityX509TrustManager.class.getName());
    private SecurityHandler handler;
    private String host;

    public MediumSecurityX509TrustManager(String string, SecurityHandler securityHandler, KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException {
        this.host = string;
        this.handler = securityHandler;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray.length == 0) {
            throw new NoSuchAlgorithmException("no trust manager found");
        }
        this.standardTrustManager = (X509TrustManager)trustManagerArray[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(x509CertificateArray, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (x509CertificateArray != null && x509CertificateArray.length == 1 && this.handler != null) {
            x509CertificateArray[0].checkValidity();
            if (!this.handler.isServerTrusted(this.host, x509CertificateArray[0])) {
                throw new CertificateException("Self signed certificate from " + x509CertificateArray[0].getIssuerX500Principal().toString() + " is not trusted");
            }
        } else {
            this.standardTrustManager.checkServerTrusted(x509CertificateArray, string);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

