/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.http.Constants;
import org.jdesktop.http.Header;
import org.jdesktop.http.Method;
import org.jdesktop.http.Parameter;
import org.jdesktop.xpath.XPathUtils;
import org.w3c.dom.Document;

public class Request
extends AbstractBean
implements Constants {
    private Map<String, Header> headers = new HashMap<String, Header>();
    private Map<String, Parameter> params = new HashMap<String, Parameter>();
    private boolean followRedirects = true;
    private Method method = Method.GET;
    private String url;
    private InputStream requestBody;
    private String username;
    private char[] password;
    private String stringBody;

    public Request() {
        this(Method.GET, null);
    }

    public Request(String string) {
        this(Method.GET, string);
    }

    public Request(Method method, String string) {
        this.method = method == null ? Method.GET : method;
        this.setHeader("Accept-Encoding", "gzip");
        this.setHeader("Content-Type", "text/plain; charset=UTF-8");
        if (string != null) {
            this.setUrlImpl(string);
        }
    }

    public Request(Request request) {
        if (request != null) {
            this.username = request.username;
            this.password = request.password;
            this.headers.putAll(request.headers);
            this.params.putAll(request.params);
            this.followRedirects = request.followRedirects;
            this.method = request.method;
            this.url = request.url;
        }
    }

    public final Header getHeader(String string) {
        if (string == null) {
            return null;
        }
        return this.headers.get(string.toLowerCase());
    }

    public final void setHeader(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.setHeader(new Header(string, string2));
    }

    public final void setHeader(String string, String string2, Header.Element ... elementArray) {
        if (string == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.setHeader(new Header(string, string2, elementArray));
    }

    public void setHeader(Header header) {
        if (header == null) {
            throw new IllegalArgumentException("header cannot be null");
        }
        if (header.getName() == null) {
            throw new IllegalArgumentException("header name cannot be null");
        }
        this.headers.put(header.getName().toLowerCase(), header);
        if ("Authorization".equals(header.getName())) {
            try {
                String string = header.getValue().substring(6);
                String string2 = Request.base64Decode(string);
                String string3 = string2.substring(0, string2.indexOf(":"));
                String string4 = string2.substring(string2.indexOf(":") + 1);
                String string5 = this.username;
                this.username = string3;
                this.firePropertyChange("username", string5, this.username);
                this.password = string4.toCharArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void removeHeader(Header header) {
        if (header != null) {
            this.headers.remove(header.getName().toLowerCase());
        }
    }

    public final void removeHeader(String string) {
        this.headers.remove(string.toLowerCase());
    }

    public final Header[] getHeaders() {
        return this.headers.values().toArray(new Header[0]);
    }

    public final void setHeaders(Header ... headerArray) {
        this.headers.clear();
        if (headerArray != null) {
            for (Header header : headerArray) {
                this.setHeader(header);
            }
        }
    }

    public final Parameter getParameter(String string) {
        if (string == null) {
            return null;
        }
        return this.params.get(string);
    }

    public final void setParameter(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter name cannot be null");
        }
        this.setParameter(new Parameter(string, string2));
    }

    public void setParameter(Parameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("param cannot be null");
        }
        if (parameter.getName() == null) {
            throw new IllegalArgumentException("parameter name cannot be null");
        }
        this.params.put(parameter.getName(), parameter);
    }

    public final Parameter[] getParameters() {
        return this.params.values().toArray(new Parameter[0]);
    }

    public final void setParameters(Parameter ... parameterArray) {
        this.params.clear();
        if (parameterArray != null) {
            for (Parameter parameter : parameterArray) {
                this.setParameter(parameter);
            }
        }
    }

    public void setFollowRedirects(boolean bl) {
        boolean bl2 = this.getFollowRedirects();
        this.followRedirects = bl;
        this.firePropertyChange("followRedirects", bl2, this.followRedirects);
    }

    public final boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setMethod(Method method) {
        Method method2 = this.getMethod();
        this.method = method == null ? Method.GET : method;
        this.firePropertyChange("method", (Object)method2, (Object)this.method);
    }

    public final Method getMethod() {
        return this.method;
    }

    public void setUrl(String string) throws IllegalArgumentException {
        String string2 = this.getUrl();
        this.setUrlImpl(string);
        this.firePropertyChange("url", string2, this.url);
    }

    private void setUrlImpl(String string) {
        int n;
        this.url = string;
        if (string != null && (n = string.indexOf("?")) >= 0) {
            String[] stringArray;
            this.url = string.substring(0, n);
            for (String string2 : stringArray = string.substring(n + 1).split("&")) {
                String string3 = null;
                String string4 = null;
                n = string2.indexOf("=");
                if (n < 0) {
                    string3 = string2;
                } else {
                    string3 = string2.substring(0, n);
                    string4 = string2.substring(n + 1);
                }
                try {
                    string3 = URLDecoder.decode(string3, "UTF-8");
                    string4 = URLDecoder.decode(string4, "UTF-8");
                    this.setParameter(string3, string4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public final String getUrl() {
        return this.url;
    }

    public void setUsername(String string) {
        String string2 = this.username;
        this.username = string;
        this.resetAuthenticationHeader();
        this.firePropertyChange("username", string2, this.username);
    }

    private void resetAuthenticationHeader() {
        try {
            if (this.username == null) {
                this.removeHeader("Authorization");
            } else {
                this.headers.put("Authorization", new Header("Authorization", "Basic " + Request.base64Encode(this.username + ":" + this.getPassword())));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final String getUsername() {
        return this.username;
    }

    public void setPassword(String string) {
        this.password = string == null ? new char[]{} : string.toCharArray();
        this.resetAuthenticationHeader();
    }

    public final String getPassword() {
        return this.password == null ? "" : new String(this.password);
    }

    public void setBody(String string) {
        this.stringBody = string;
        this.setBody(string == null ? null : string.getBytes());
    }

    public void setBody(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            this.requestBody = null;
        } else {
            this.setBody(new ByteArrayInputStream(byArray));
        }
    }

    public void setBody(Document document) {
        this.setBody(document == null ? null : XPathUtils.toXML(document));
    }

    public void setBody(InputStream inputStream) {
        this.requestBody = inputStream;
    }

    protected InputStream getBody() throws Exception {
        return this.requestBody;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((Object)this.getMethod());
        stringBuffer.append(" " + this.getUrl() + "\n");
        for (Header header : this.getHeaders()) {
            stringBuffer.append("  ").append(header.getName()).append(": ").append(header.getValue());
            stringBuffer.append("\n");
        }
        if (this.stringBody != null) {
            stringBuffer.append(this.stringBody);
        } else {
            stringBuffer.append("<<body content>>");
        }
        return stringBuffer.toString();
    }

    private static String base64Encode(String string) throws Exception {
        return new String(Base64.getEncoder().encode(string.getBytes()));
    }

    private static String base64Decode(String string) throws Exception {
        return new String(Base64.getDecoder().decode(string));
    }
}

