/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.jdesktop.http.Header;
import org.jdesktop.http.StatusCode;

public class Response {
    private String charset;
    private Set<Header> headers;
    private StatusCode statusCode;
    private String statusText;
    private byte[] responseBody;
    private String url;

    Response(StatusCode statusCode, String string, byte[] byArray, String string2, Set<Header> set, String string3) {
        if (statusCode == null) {
            throw new NullPointerException("statusCode cannot be null");
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        if (string3 != null) {
            // empty if block
        }
        this.statusCode = statusCode;
        this.statusText = string;
        this.responseBody = byArray;
        this.charset = string2 == null ? "ISO-8859-1" : string2;
        this.url = string3;
        this.headers = new HashSet<Header>();
        if (set != null) {
            for (Header header : set) {
                if (header == null) {
                    throw new IllegalArgumentException("There was a null header in the results.");
                }
                this.headers.add(header);
            }
        }
    }

    public Header getHeader(String string) {
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        for (Header header : this.headers) {
            if (!string.equalsIgnoreCase(header.getName())) continue;
            return header;
        }
        return null;
    }

    public Header[] getHeaders() {
        return this.headers.toArray(new Header[0]);
    }

    public Date getLastModified() {
        Header header = this.getHeader("Last-Modified");
        if (header == null) {
            return null;
        }
        try {
            String string = header.getValue();
            Long l = Long.parseLong(string);
            return new Date(l);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public InputStream getBodyAsStream() {
        return new ByteArrayInputStream(this.getBodyAsBytes());
    }

    public Reader getBodyAsReader() {
        if (this.responseBody == null) {
            return new StringReader("");
        }
        return new StringReader(this.getBody());
    }

    public byte[] getBodyAsBytes() {
        return this.responseBody == null ? new byte[]{} : this.responseBody;
    }

    public String getBody() {
        try {
            return this.responseBody == null ? "" : new String(this.responseBody, this.charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return this.responseBody == null ? "" : new String(this.responseBody);
        }
    }

    public String getBaseUrl() {
        return this.url;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ").append((Object)this.statusCode).append("\n");
        for (Header header : this.getHeaders()) {
            stringBuffer.append("  ").append(header.getName()).append(": ").append(header.getValue());
            stringBuffer.append("\n");
        }
        stringBuffer.append(this.getBody());
        return stringBuffer.toString();
    }
}

