/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http.async;

import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.http.Constants;
import org.jdesktop.http.Header;
import org.jdesktop.http.Method;
import org.jdesktop.http.Parameter;
import org.jdesktop.http.Request;
import org.jdesktop.http.Response;
import org.jdesktop.http.Session;
import org.jdesktop.xpath.XPathUtils;
import org.w3c.dom.Document;

public class AsyncHttpRequest
extends AbstractBean
implements Constants {
    private ReadyState readyState = ReadyState.UNINITIALIZED;
    private String responseText;
    private int status;
    private String statusText;
    private AsyncWorker worker;
    private boolean asyncFlag;
    private Session s;
    private Exception exception;
    private PropertyChangeListener onReadyStateChange;
    private Request req = new Request();

    public void setSession(Session session) {
        Session session2 = this.getSession();
        this.s = session;
        this.firePropertyChange("session", session2, this.getSession());
    }

    public Session getSession() {
        return this.s;
    }

    public void setOnReadyStateChange(PropertyChangeListener propertyChangeListener) {
        PropertyChangeListener propertyChangeListener2 = this.getOnReadyStateChange();
        this.removeReadyStateChangeListener(propertyChangeListener2);
        this.addReadyStateChangeListener(propertyChangeListener);
        this.onReadyStateChange = propertyChangeListener;
        this.firePropertyChange("onReadyStateChange", propertyChangeListener2, propertyChangeListener);
    }

    public final PropertyChangeListener getOnReadyStateChange() {
        return this.onReadyStateChange;
    }

    public final ReadyState getReadyState() {
        return this.readyState;
    }

    public void open(Method method, String string) {
        this.open(method, string, true);
    }

    public void open(Method method, String string, boolean bl) {
        this.open(method, string, bl, null, null);
    }

    private void open(Method method, String string, boolean bl, String string2) {
        this.open(method, string, bl, string2, null);
    }

    public void open(Method method, String string, boolean bl, String string2, String string3) {
        if (this.worker != null && (this.readyState == ReadyState.SENT || this.readyState == ReadyState.RECEIVING)) {
            throw new IllegalStateException("You must abort() the current task, or wait for it to finish completing before starting a new one!");
        }
        try {
            new URL(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        this.reset();
        this.asyncFlag = bl;
        this.req.setUrl(string);
        this.req.setMethod(method);
        this.req.setUsername(string2);
        this.req.setPassword(string3);
        this.setReadyState(ReadyState.OPEN);
    }

    public void setUsername(String string) {
        this.req.setUsername(string);
    }

    public void setPassword(String string) {
        this.req.setPassword(string);
    }

    public String getUsername() {
        return this.req.getUsername();
    }

    public String getPassword() {
        return this.req.getPassword();
    }

    public void setRequestHeader(String string, String string2) {
        if (this.getReadyState() != ReadyState.OPEN) {
            throw new IllegalStateException("The AsyncHttpRequest must be opened prior to setting a request header");
        }
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Neither the header, nor value, may be null");
        }
        if (string.equalsIgnoreCase("Accept-Charset") || string.equalsIgnoreCase("Accept-Encoding") || string.equalsIgnoreCase("Content-Length") || string.equalsIgnoreCase("Expect") || string.equalsIgnoreCase("Date") || string.equalsIgnoreCase("Host") || string.equalsIgnoreCase("Keep-Alive") || string.equalsIgnoreCase("Referer") || string.equalsIgnoreCase("TE") || string.equalsIgnoreCase("Trailer") || string.equalsIgnoreCase("Transfer-Encoding") || string.equalsIgnoreCase("Upgrade")) {
            // empty if block
        }
        if (string.equalsIgnoreCase("Authorization") || string.equalsIgnoreCase("Content-Base") || string.equalsIgnoreCase("Content-Location") || string.equalsIgnoreCase("Content-MD5") || string.equalsIgnoreCase("Content-Range") || string.equalsIgnoreCase("Content-Type") || string.equalsIgnoreCase("Content-Version") || string.equalsIgnoreCase("Delta-Base") || string.equalsIgnoreCase("Depth") || string.equalsIgnoreCase("Destination") || string.equalsIgnoreCase("ETag") || string.equalsIgnoreCase("Expect") || string.equalsIgnoreCase("From") || string.equalsIgnoreCase("If-Modified-Since") || string.equalsIgnoreCase("If-Range") || string.equalsIgnoreCase("If-Unmodified-Since") || string.equalsIgnoreCase("Max-Forwards") || string.equalsIgnoreCase("MIME-Version") || string.equalsIgnoreCase("Overwrite") || string.equalsIgnoreCase("Proxy-Authorization") || string.equalsIgnoreCase("SOAPAction") || string.equalsIgnoreCase("Timeout")) {
            for (Header header : this.req.getHeaders()) {
                if (!header.getName().equalsIgnoreCase(string)) continue;
                this.req.removeHeader(header);
                this.req.setHeader(new Header(string, string2));
                break;
            }
        } else {
            boolean bl = false;
            for (Header header : this.req.getHeaders()) {
                if (!header.getName().equalsIgnoreCase(string)) continue;
                this.req.removeHeader(header);
                this.req.setHeader(new Header(string, header.getValue() + ", " + string2));
                bl = true;
                break;
            }
            if (!bl) {
                this.req.setHeader(new Header(string, string2));
            }
        }
    }

    public void send() {
        this.send((String)null);
    }

    public void send(String string) {
        if (this.readyState != ReadyState.OPEN) {
            throw new IllegalStateException("AsyncHttpRequest must be in an OPEN state before invokation of the send() method");
        }
        this.worker = this.createAsyncWorker(string);
        this.worker.sendRequest(this.getSession(), string);
    }

    public void send(Document document) {
        if (document == null) {
            this.send((String)null);
        } else {
            this.send(XPathUtils.toXML(document));
        }
    }

    public void abort() {
        if (this.worker != null) {
            this.worker.cancel(true);
            this.worker = null;
        }
        this.reset();
    }

    public String getAllResponseHeaders() {
        if (this.readyState == ReadyState.RECEIVING || this.readyState == ReadyState.LOADED) {
            StringBuffer stringBuffer = new StringBuffer();
            for (Header header : this.worker.response.getHeaders()) {
                stringBuffer.append(header.toString());
                stringBuffer.append("\r\n");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public String getResponseHeader(String string) {
        if (this.readyState == ReadyState.RECEIVING || this.readyState == ReadyState.LOADED) {
            Header header = this.worker.response.getHeader(string);
            return header == null ? null : header.getValue();
        }
        return null;
    }

    public String getResponseText() {
        if (this.readyState == ReadyState.RECEIVING) {
            return this.responseText == null ? "" : this.responseText;
        }
        if (this.readyState == ReadyState.LOADED) {
            return this.responseText;
        }
        return "";
    }

    public int getStatus() {
        if (this.readyState == ReadyState.RECEIVING || this.readyState == ReadyState.LOADED) {
            return this.status;
        }
        throw new IllegalStateException("You cannot call getStatus() unless readyState == RECEIVING || LOADING");
    }

    public String getStatusText() {
        if (this.readyState == ReadyState.RECEIVING || this.readyState == ReadyState.LOADED) {
            return this.statusText;
        }
        throw new IllegalStateException("You cannot call getStatusText() unless readyState == RECEIVING || LOADING");
    }

    public void setFollowsRedirects(boolean bl) {
        if (this.readyState != ReadyState.OPEN) {
            throw new IllegalStateException("The request must be OPEN before setting the follows redirects flag");
        }
        this.req.setFollowRedirects(bl);
    }

    public final boolean getFollowRedirects() {
        return this.req.getFollowRedirects();
    }

    public Exception getException() {
        if (this.readyState == ReadyState.LOADED) {
            return this.exception;
        }
        return null;
    }

    public Parameter getParameter(String string) {
        return this.req.getParameter(string);
    }

    public void setParameter(Parameter parameter) {
        this.req.setParameter(parameter);
    }

    public void setParameter(String string, String string2) {
        this.setParameter(new Parameter(string, string2));
    }

    public Parameter[] getParameters() {
        return this.req.getParameters();
    }

    public void setParameters(Parameter ... parameterArray) {
        this.req.setParameters(parameterArray);
    }

    public void addReadyStateChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener("readyState", propertyChangeListener);
    }

    public void removeReadyStateChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener("readyState", propertyChangeListener);
    }

    public PropertyChangeListener[] getReadyStateChangeListeners() {
        return super.getPropertyChangeListeners("readyState");
    }

    protected AsyncWorker createAsyncWorker(String string) {
        return new AsyncWorker();
    }

    protected void reset() {
        this.exception = null;
        this.req = new Request();
        this.req.setFollowRedirects(false);
        String string = this.responseText;
        this.responseText = null;
        this.firePropertyChange("responseText", string, null);
        this.setStatus(-1);
        this.setStatusText(null);
        this.setReadyState(ReadyState.UNINITIALIZED);
    }

    protected void handleResponse(String string) throws Exception {
    }

    private void setReadyState(ReadyState readyState) {
        ReadyState readyState2 = this.readyState;
        this.readyState = readyState;
        this.firePropertyChange("readyState", (Object)readyState2, (Object)this.readyState);
    }

    private void setStatus(int n) {
        int n2 = this.status;
        this.status = n;
        this.firePropertyChange("status", n2, this.status);
    }

    private void setStatusText(String string) {
        String string2 = this.statusText;
        this.statusText = string;
        this.firePropertyChange("statusText", string2, this.statusText);
    }

    protected class AsyncWorker
    extends SwingWorker {
        private String data;
        private Session s;
        private Response response;

        protected AsyncWorker() {
        }

        private void sendRequest(Session session, String string) {
            this.s = session == null ? new Session() : session;
            this.safeSetReadyState(ReadyState.SENT);
            this.data = string;
            if (AsyncHttpRequest.this.asyncFlag) {
                this.execute();
            } else {
                this.run();
                this.done();
            }
        }

        protected Object doInBackground() throws Exception {
            try {
                this.response = null;
                AsyncHttpRequest.this.req.setBody(this.data);
                this.response = this.s.execute(AsyncHttpRequest.this.req);
                AsyncHttpRequest.this.setStatus(this.response.getStatusCode().getCode());
                AsyncHttpRequest.this.setStatusText(this.response.getStatusText());
                this.safeSetReadyState(ReadyState.RECEIVING);
                AsyncHttpRequest.this.responseText = this.response.getBody();
                AsyncHttpRequest.this.handleResponse(AsyncHttpRequest.this.responseText);
                return AsyncHttpRequest.this.responseText;
            }
            catch (Exception exception) {
                AsyncHttpRequest.this.exception = exception;
                return null;
            }
        }

        protected void safeSetReadyState(final ReadyState readyState) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AsyncHttpRequest.this.setReadyState(readyState);
                    }
                });
            } else {
                AsyncHttpRequest.this.setReadyState(readyState);
            }
        }

        @Override
        protected void done() {
            AsyncHttpRequest.this.setReadyState(ReadyState.LOADED);
        }
    }

    public static enum ReadyState {
        UNINITIALIZED,
        OPEN,
        SENT,
        RECEIVING,
        LOADED;

    }
}

