/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.stream.plugin.javascript.api;

import java.net.URI;
import org.voltdb.stream.processor.VoltSP;

@VoltSP.Documentation(description="This plugin allows execution of JavaScript code on streamed data using the GraalVM JavaScript engine.\n\n## Features\n\n- Execute JavaScript code on input data\n- Load JavaScript code from a file or provide it inline\n- Access input data from JavaScript\n- Emit output data from JavaScript\n\nThe JavaScript processor can also be configured to limit script execution time.\n\n## JavaScript API\n\nThe JavaScript code can access the `input` data passed to the processor.\n\nThe JavaScript code should define a `process` function that takes the input data and returns the output data:\n\n```javascript\nfunction process(input) {\n  // Process the input data\n  return output;\n}\n```\n\n## Security Considerations\n\nThe JavaScript processor runs with limited permissions by default. It cannot access the file system, network, or other system resources unless explicitly allowed.\n", examples={@VoltSP.Documentation.Example(language=VoltSP.ConfigurationLanguage.YAML, inline="Capitalise all strings.\n\n```yaml\nversion: 1\nname: JavaScriptProcessorExample\n\nsource:\n  file:\n    path: \"input.txt\"\n\nprocessors:\n  - javascript:\n      script: |\n        function process(input) {\n          if (typeof input === 'string') {\n            return input.toUpperCase();\n          }\n          return input;\n        }\n\nsink:\n  stdout: {}\n```\n")})
@VoltSP.Processor(name="javascript", implementation="org.voltdb.stream.plugin.javascript.JavaScriptProcessor")
public record JavaScriptProcessorConfig(@VoltSP.Documentation.Field(description="JavaScript code to execute") String script, @VoltSP.Documentation.Field(description="URL to a JavaScript file to execute") URI scriptUrl) {
    public JavaScriptProcessorConfig {
        if (script == null && scriptUrl == null) {
            throw new IllegalArgumentException("Either script or scriptUrl must be provided");
        }
    }
}

