/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.stream.plugin.python.api;

import java.net.URI;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.voltdb.stream.api.extension.VoltStreamFunctionConfigurator;
import org.voltdb.stream.execution.Configuration;
import org.voltdb.stream.plugin.python.api.PythonProcessorConfig;
import org.voltdb.stream.utils.DurationParser;

public final class PythonProcessorConfigBuilder
implements VoltStreamFunctionConfigurator<Object, Object> {
    public static final String CONFIG_PATH = "processor.python";
    private String script;
    private URI scriptUrl;
    private Duration timeout = DurationParser.parse((Object)"1s");

    public PythonProcessorConfigBuilder() {
        this.autoConfigureBuilder();
    }

    public PythonProcessorConfigBuilder configure(String path) {
        if (!this.getConfiguration().findByPath(path, new String[0]).hasValue()) {
            throw new IllegalArgumentException("No configuration found for path:" + path);
        }
        this.configureBuilder(this.getConfiguration(), path);
        return this;
    }

    private void autoConfigureBuilder() {
        if (this.getConfiguration() != null && this.getConfiguration().findByPath(CONFIG_PATH, new String[0]).hasValue()) {
            this.configureBuilder(this.getConfiguration(), CONFIG_PATH);
        }
    }

    public PythonProcessorConfig build() {
        return new PythonProcessorConfig(this.script, this.scriptUrl, this.timeout);
    }

    public PythonProcessorConfigBuilder withScript(String script) {
        this.script = script;
        return this;
    }

    public PythonProcessorConfigBuilder withScriptUrl(URI scriptUrl) {
        this.scriptUrl = scriptUrl;
        return this;
    }

    public PythonProcessorConfigBuilder withScriptUrl(String path) {
        this.scriptUrl = URI.create(path);
        return this;
    }

    public PythonProcessorConfigBuilder withTimeout(long amount, TimeUnit unit) {
        this.timeout = Duration.of(amount, unit.toChronoUnit());
        return this;
    }

    public PythonProcessorConfigBuilder withTimeoutString(String durationString) {
        this.timeout = DurationParser.parse((Object)durationString);
        return this;
    }

    public PythonProcessorConfigBuilder withTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    private <T extends Enum> T fromString(T[] enums, String path, String value) {
        for (T e : enums) {
            if (!((Enum)e).name().equalsIgnoreCase(value)) continue;
            return e;
        }
        throw new IllegalArgumentException("The value for '" + path + "' is invalid: '" + value + "'");
    }

    public void configureBuilder(Configuration configuration, String path) {
        Configuration.ConfigurationPart part = configuration.findByPath(path, new String[]{"script"});
        if (part.hasValue()) {
            this.script = part.asString();
        }
        if ((part = configuration.findByPath(path, new String[]{"scriptUrl"})).hasValue()) {
            this.scriptUrl = URI.create(part.asString());
        }
        if ((part = configuration.findByPath(path, new String[]{"timeout"})).hasValue()) {
            this.timeout = DurationParser.parse((Object)part.getValue());
        }
    }

    public static PythonProcessorConfigBuilder builder() {
        return new PythonProcessorConfigBuilder();
    }
}

