/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.webservices.adminapi.sdk;

import java.io.IOException;
import java.io.InputStream;
import org.apache.roller.webservices.adminapi.sdk.Entry;
import org.apache.roller.webservices.adminapi.sdk.Service;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;

public class MemberEntry
extends Entry {
    private String name;
    private String handle;
    private String permission;

    public MemberEntry(Element e, String urlPrefix) {
        this.populate(e, urlPrefix);
    }

    public MemberEntry(String handle, String userName, String urlPrefix) {
        String href = urlPrefix + "/" + "members" + "/" + handle + "/" + userName;
        this.setHref(href);
        this.setHandle(handle);
        this.setName(userName);
    }

    public MemberEntry(InputStream stream, String urlPrefix) throws JDOMException, IOException {
        SAXBuilder sb = new SAXBuilder();
        Document d = sb.build(stream);
        Element e = d.detachRootElement();
        this.populate(e, urlPrefix);
    }

    private void populate(Element e, String urlPrefix) {
        Element handleElement;
        Element nameElement = e.getChild("name", NAMESPACE);
        if (nameElement != null) {
            this.setName(nameElement.getText());
        }
        if ((handleElement = e.getChild("handle", NAMESPACE)) != null) {
            this.setHandle(handleElement.getText());
        }
        this.setHref(urlPrefix + "/" + "members" + "/" + this.getHandle() + "/" + this.getName());
        Element permissionElement = e.getChild("permission", NAMESPACE);
        if (permissionElement != null) {
            this.setPermission(permissionElement.getText());
        }
    }

    public String getType() {
        return "member";
    }

    public Document toDocument() {
        String perm;
        String handle;
        Element member = new Element("member", NAMESPACE);
        Document doc = new Document(member);
        member.setAttribute("href", this.getHref());
        String name = this.getName();
        if (name != null) {
            Element nameElement = new Element("name", Service.NAMESPACE);
            Text nameText = new Text(name);
            nameElement.addContent((Content)nameText);
            member.addContent((Content)nameElement);
        }
        if ((handle = this.getHandle()) != null) {
            Element handleElement = new Element("handle", NAMESPACE);
            Text handleText = new Text(handle);
            handleElement.addContent((Content)handleText);
            member.addContent((Content)handleElement);
        }
        if ((perm = this.getPermission()) != null) {
            Element permissionElement = new Element("permission", NAMESPACE);
            Text permissionText = new Text(perm);
            permissionElement.addContent((Content)permissionText);
            member.addContent((Content)permissionElement);
        }
        return doc;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        MemberEntry other = (MemberEntry)o;
        if (!MemberEntry.areEqual(this.getHandle(), other.getHandle())) {
            return false;
        }
        if (!MemberEntry.areEqual(this.getName(), other.getName())) {
            return false;
        }
        if (!MemberEntry.areEqual(this.getPermission(), other.getPermission())) {
            return false;
        }
        return super.equals(o);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    static interface Tags {
        public static final String MEMBER = "member";
        public static final String NAME = "name";
        public static final String HANDLE = "handle";
        public static final String PERMISSION = "permission";
    }

    public static interface Permissions {
        public static final String ADMIN = "ADMIN";
        public static final String AUTHOR = "AUTHOR";
        public static final String LIMITED = "LIMITED";
    }
}

