/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.webservices.adminapi.sdk;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.roller.webservices.adminapi.sdk.Entry;
import org.apache.roller.webservices.adminapi.sdk.EntrySet;
import org.apache.roller.webservices.adminapi.sdk.Service;
import org.apache.roller.webservices.adminapi.sdk.UnexpectedRootElementException;
import org.apache.roller.webservices.adminapi.sdk.WeblogEntry;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class WeblogEntrySet
extends EntrySet {
    public WeblogEntrySet(String urlPrefix) {
        this.setHref(urlPrefix + "/" + "weblogs");
    }

    public WeblogEntrySet(Document d, String urlPrefix) throws UnexpectedRootElementException {
        this.populate(d, urlPrefix);
    }

    public WeblogEntrySet(InputStream stream, String urlPrefix) throws JDOMException, IOException, UnexpectedRootElementException {
        SAXBuilder sb = new SAXBuilder();
        Document d = sb.build(stream);
        this.populate(d, urlPrefix);
    }

    private void populate(Document d, String urlPrefix) throws UnexpectedRootElementException {
        Element root = d.getRootElement();
        String rootName = root.getName();
        if (!rootName.equals("weblogs")) {
            throw new UnexpectedRootElementException("ERROR: Unexpected root element", "weblogs", rootName);
        }
        List weblogs = root.getChildren("weblog", Service.NAMESPACE);
        if (weblogs != null) {
            ArrayList<WeblogEntry> entries = new ArrayList<WeblogEntry>();
            Iterator i = weblogs.iterator();
            while (i.hasNext()) {
                Element weblog = (Element)i.next();
                WeblogEntry entry = new WeblogEntry(weblog, urlPrefix);
                entries.add(entry);
            }
            this.setEntries(entries.toArray(new Entry[0]));
        }
        this.setHref(urlPrefix + "/" + "weblogs");
    }

    public String getType() {
        return "weblogs";
    }

    static interface Tags {
        public static final String WEBLOGS = "weblogs";
    }
}

