/*
 * Decompiled with CFR 0.152.
 */
package ru.greatbit.utils.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ru.greatbit.utils.collection.Difference;
import ru.greatbit.utils.serialize.JsonSerializer;
import ru.greatbit.utils.string.StringUtils;

public class CollectionUtils {
    public static <T> List<T> mergeLists(List<T> first, List<T> second) {
        Map<T, T> dataMap = CollectionUtils.listToMap(first);
        for (T object : second) {
            dataMap.put(object, object);
        }
        LinkedList<T> resultObject = new LinkedList<T>();
        for (T object : dataMap.keySet()) {
            resultObject.add(object);
        }
        return resultObject;
    }

    public static <T> List<T> mergeListsByValue(List<T> first, List<T> second) throws Exception {
        Map<String, T> dataMap = CollectionUtils.listToMD5Map(first);
        for (T object : second) {
            dataMap.put(StringUtils.getMd5String(JsonSerializer.marshal(object)), object);
        }
        LinkedList<T> resultObject = new LinkedList<T>();
        for (String key : dataMap.keySet()) {
            resultObject.add(dataMap.get(key));
        }
        return resultObject;
    }

    public static <T> Difference getDiff(List<T> first, List<T> second) {
        return CollectionUtils.getDiff(CollectionUtils.listToMap(first), CollectionUtils.listToMap(second));
    }

    public static <T> Difference getDiffAnyObject(List<T> first, List<T> second) throws Exception {
        return CollectionUtils.getDiff(CollectionUtils.listToMD5Map(first), CollectionUtils.listToMD5Map(second));
    }

    private static <K, V> Difference getDiff(Map<K, V> firstMap, Map<K, V> secondMap) {
        V value;
        Difference difference = new Difference();
        for (K object : secondMap.keySet()) {
            value = firstMap.get(object);
            if (value == null) {
                difference.getAdded().add(secondMap.get(object));
                continue;
            }
            difference.getEqual().add(value);
        }
        for (K object : firstMap.keySet()) {
            value = secondMap.get(object);
            if (value != null) continue;
            difference.getRemoved().add(firstMap.get(object));
        }
        return difference;
    }

    public static <V> Map<V, V> listToMap(List<V> input) {
        HashMap<V, V> dataMap = new HashMap<V, V>();
        for (V object : input) {
            dataMap.put(object, object);
        }
        return dataMap;
    }

    public static <T> Map<String, T> listToMD5Map(List<T> input) throws Exception {
        HashMap<String, T> dataMap = new HashMap<String, T>();
        for (T object : input) {
            dataMap.put(StringUtils.getMd5String(JsonSerializer.marshal(object)), object);
        }
        return dataMap;
    }

    public static <T> List<T> removeByIndex(List<T> input, int index) {
        LinkedList<T> result = new LinkedList<T>(input);
        result.remove(index);
        if (input.getClass().getName().equals("java.util.Arrays$ArrayList")) {
            input = Arrays.asList(result.toArray());
        } else {
            input.clear();
            input.addAll(result);
        }
        return input;
    }

    public static <T, K> Map<K, List<T>> removeDuplicateValues(Map<K, List<T>> values) {
        if (values == null) {
            return values;
        }
        LinkedHashMap<K, List<T>> newValues = new LinkedHashMap<K, List<T>>();
        for (K key : values.keySet()) {
            newValues.put(key, CollectionUtils.removeDuplicateValues(values.get(key)));
        }
        return newValues;
    }

    public static <T> List<T> removeDuplicateValues(List<T> values) {
        if (values == null) {
            return values;
        }
        return new ArrayList<T>(new HashSet<T>(values));
    }

    public static <T extends Comparable> List<T> reorder(List<T> elements, List<T> order) {
        int i;
        LinkedHashMap<T, Long> orderMap = new LinkedHashMap<T, Long>();
        for (i = 0; i < order.size(); ++i) {
            orderMap.put(order.get(i), new Long(i));
        }
        for (i = 0; i < elements.size(); ++i) {
            for (int j = i + 1; j < elements.size(); ++j) {
                if (CollectionUtils.compare((Comparable)elements.get(i), (Comparable)elements.get(j), orderMap) <= 0) continue;
                CollectionUtils.swap(elements, i, j);
            }
        }
        return elements;
    }

    private static <T extends Comparable> int compare(T o1, T o2, Map<T, Long> orderMap) {
        Long order1 = orderMap.get(o1);
        Long order2 = orderMap.get(o2);
        if (order1 != null && order2 != null) {
            return order1.compareTo(order2);
        }
        return o1.compareTo(o2);
    }

    public static <T extends Comparable> void swap(List<T> elements, int i, int j) {
        Comparable buff = (Comparable)elements.get(j);
        elements.set(j, elements.get(i));
        elements.set(i, buff);
    }
}

