/*
 * Decompiled with CFR 0.152.
 */
package ru.greatbit.utils.refclection;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import ru.greatbit.utils.collection.CollectionUtils;
import ru.greatbit.utils.exceptions.NullObjectException;
import ru.greatbit.utils.string.StringUtils;

public class FieldsFetcher {
    public static Object findValue(Object object, String path) throws NullObjectException, IllegalAccessException, InstantiationException {
        if (object == null) {
            throw new NullObjectException();
        }
        return FieldsFetcher.findValue(object, object.getClass(), Arrays.asList(StringUtils.emptyIfNull(path).split("\\.")));
    }

    public static Object findValue(Object object, List<String> path) throws NullObjectException, IllegalAccessException, InstantiationException {
        if (object == null) {
            throw new NullObjectException();
        }
        return FieldsFetcher.findValue(object, object.getClass(), path);
    }

    public static Object findValue(Object object, Class clazz, List<String> path) throws NullObjectException, InstantiationException, IllegalAccessException {
        if (object == null) {
            throw new NullObjectException();
        }
        if (path.size() != 0) {
            Object nextObject = FieldsFetcher.getObjectFromField(object, clazz, path.get(0).trim());
            try {
                path.remove(0);
            }
            catch (UnsupportedOperationException e) {
                path = CollectionUtils.removeByIndex(path, 0);
            }
            if (nextObject != null) {
                return FieldsFetcher.findValue(nextObject, clazz, path);
            }
        }
        return object;
    }

    public static Object getObjectFromField(Object obj, Class clazz, String fieldName) {
        Field field;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            Object result = field.get(obj);
            field.setAccessible(accessible);
            return result;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static <T> List<T> mergeListsByInterface(Object obj, Class<T> commonInterface) throws IllegalAccessException {
        Field[] fields;
        LinkedList result = new LinkedList();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            Type type = field.getGenericType();
            if (!(type instanceof ParameterizedType) || ((ParameterizedType)type).getActualTypeArguments().length <= 0 || !commonInterface.isAssignableFrom((Class)((ParameterizedType)type).getActualTypeArguments()[0])) continue;
            boolean access = field.isAccessible();
            field.setAccessible(true);
            LinkedList values = (LinkedList)field.get(obj);
            if (values == null) {
                values = new LinkedList();
            }
            result.addAll(values);
            field.setAccessible(access);
        }
        return result;
    }

    public static <T> List<T> getValuesByInterface(Object obj, Class<T> commonInterface) throws IllegalAccessException {
        Field[] fields;
        LinkedList<Object> result = new LinkedList<Object>();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            if (!commonInterface.isAssignableFrom(field.getType())) continue;
            boolean access = field.isAccessible();
            field.setAccessible(true);
            result.add(field.get(obj));
            field.setAccessible(access);
        }
        return result;
    }
}

