/*
 * Decompiled with CFR 0.152.
 */
package ru.greatbit.utils.string;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

public class StringUtils {
    private static final Map<String, String> letters = new HashMap<String, String>();

    public static String translit(String text) {
        StringBuilder sb = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            String l = text.substring(i, i + 1);
            if (letters.containsKey(l)) {
                sb.append(letters.get(l));
                continue;
            }
            sb.append(l);
        }
        return sb.toString();
    }

    public static String emptyIfNull(String input) {
        if (input == null) {
            return "";
        }
        return input;
    }

    public static <T> String listAsString(List<T> stringList) {
        String result = stringList.toString();
        result = StringUtils.removeHeading(result, "[");
        result = StringUtils.removeTailing(result, "]");
        result.trim();
        return result;
    }

    public static <T> String listAsStringNoSpaces(List<T> stringList) {
        StringBuffer sb = new StringBuffer();
        for (T obj : stringList) {
            sb.append(obj).append(",");
        }
        return StringUtils.removeTailing(sb.toString(), ",").trim();
    }

    public static String getMd5String(String input) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.reset();
        messageDigest.update(input.getBytes(Charset.forName("UTF8")));
        byte[] resultByte = messageDigest.digest();
        String result = Hex.encodeHexString((byte[])resultByte);
        return result;
    }

    public static List<String> addUniqueString(String toAdd, List<String> strings) {
        if (!strings.contains(toAdd = StringUtils.emptyIfNull(toAdd))) {
            strings.add(toAdd);
        }
        return strings;
    }

    public static boolean containsAll(String source, String ... toSearch) {
        if (source == null || toSearch == null || toSearch.length == 0) {
            return false;
        }
        for (String entry : toSearch) {
            if (source.contains(entry)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAny(String source, String ... toSearch) {
        if (source == null || toSearch == null || toSearch.length == 0) {
            return false;
        }
        for (String entry : toSearch) {
            if (!source.contains(entry)) continue;
            return true;
        }
        return false;
    }

    public static String removeTailing(String source, String toRemove) {
        if (toRemove == null) {
            return source;
        }
        source = source.trim();
        int toRemoveLength = toRemove.length();
        int sourceRemoveLengthDiff = source.length() - toRemoveLength;
        if (source.length() >= toRemoveLength && toRemove.equals(source.substring(sourceRemoveLengthDiff))) {
            source = source.substring(0, sourceRemoveLengthDiff);
        }
        return source;
    }

    public static String removeHeading(String source, String toRemove) {
        if (toRemove == null) {
            return source;
        }
        source = source.trim();
        int toRemoveLength = toRemove.length();
        if (source.length() >= toRemoveLength && toRemove.equals(source.substring(0, toRemoveLength))) {
            source = source.substring(toRemoveLength, source.length());
        }
        return source;
    }

    public static String lcs(String firstString, String secondString) {
        int[][] lengths = new int[firstString.length() + 1][secondString.length() + 1];
        for (int i = 0; i < firstString.length(); ++i) {
            for (int j = 0; j < secondString.length(); ++j) {
                lengths[i + 1][j + 1] = firstString.charAt(i) == secondString.charAt(j) ? lengths[i][j] + 1 : Math.max(lengths[i + 1][j], lengths[i][j + 1]);
            }
        }
        StringBuffer sb = new StringBuffer();
        int x = firstString.length();
        int y = secondString.length();
        while (x != 0 && y != 0) {
            if (lengths[x][y] == lengths[x - 1][y]) {
                --x;
                continue;
            }
            if (lengths[x][y] == lengths[x][y - 1]) {
                --y;
                continue;
            }
            assert (firstString.charAt(x - 1) == secondString.charAt(y - 1));
            sb.append(firstString.charAt(x - 1));
            --x;
            --y;
        }
        return sb.reverse().toString();
    }

    static {
        letters.put("\u0410", "A");
        letters.put("\u0411", "B");
        letters.put("\u0412", "V");
        letters.put("\u0413", "G");
        letters.put("\u0414", "D");
        letters.put("\u0415", "E");
        letters.put("\u0401", "E");
        letters.put("\u0416", "ZH");
        letters.put("\u0417", "Z");
        letters.put("\u0418", "I");
        letters.put("\u0419", "I");
        letters.put("\u041a", "K");
        letters.put("\u041b", "L");
        letters.put("\u041c", "M");
        letters.put("\u041d", "N");
        letters.put("\u041e", "O");
        letters.put("\u041f", "P");
        letters.put("\u0420", "R");
        letters.put("\u0421", "S");
        letters.put("\u0422", "T");
        letters.put("\u0423", "U");
        letters.put("\u0424", "F");
        letters.put("\u0425", "H");
        letters.put("\u0426", "C");
        letters.put("\u0427", "CH");
        letters.put("\u0428", "SH");
        letters.put("\u0429", "SH");
        letters.put("\u042a", "'");
        letters.put("\u042b", "Y");
        letters.put("\u042a", "'");
        letters.put("\u042d", "E");
        letters.put("\u042e", "U");
        letters.put("\u042f", "YA");
        letters.put("\u0430", "a");
        letters.put("\u0431", "b");
        letters.put("\u0432", "v");
        letters.put("\u0433", "g");
        letters.put("\u0434", "d");
        letters.put("\u0435", "e");
        letters.put("\u0451", "e");
        letters.put("\u0436", "zh");
        letters.put("\u0437", "z");
        letters.put("\u0438", "i");
        letters.put("\u0439", "i");
        letters.put("\u043a", "k");
        letters.put("\u043b", "l");
        letters.put("\u043c", "m");
        letters.put("\u043d", "n");
        letters.put("\u043e", "o");
        letters.put("\u043f", "p");
        letters.put("\u0440", "r");
        letters.put("\u0441", "s");
        letters.put("\u0442", "t");
        letters.put("\u0443", "u");
        letters.put("\u0444", "f");
        letters.put("\u0445", "h");
        letters.put("\u0446", "c");
        letters.put("\u0447", "ch");
        letters.put("\u0448", "sh");
        letters.put("\u0449", "sh");
        letters.put("\u044a", "'");
        letters.put("\u044b", "y");
        letters.put("\u044a", "'");
        letters.put("\u044d", "e");
        letters.put("\u044e", "u");
        letters.put("\u044f", "ya");
    }
}

