/*
 * Decompiled with CFR 0.152.
 */
package ru.greatbit.utils.time;

import java.util.Arrays;

public class CronUtils {
    private static final String DEFAULT_CRON = "";

    public static String convertToQuartz(String input) {
        String result = DEFAULT_CRON;
        String[] entries = input.split(" ");
        if (entries.length < 5) {
            return DEFAULT_CRON;
        }
        if ("*".equals(entries[4])) {
            entries[4] = "?";
        }
        if (!"*".equals(entries[4]) && !"?".equals(entries[4]) && "*".equals(entries[2])) {
            entries[2] = "?";
        }
        if (!"*".equals(entries[4]) && !"?".equals(entries[4])) {
            try {
                entries[4] = CronUtils.adjustDayOfWeek(entries[4]);
            }
            catch (NumberFormatException e) {
                return DEFAULT_CRON;
            }
        }
        for (String entry : Arrays.asList(entries)) {
            result = result + entry + " ";
        }
        result = "0 " + result;
        return result.trim();
    }

    private static String adjustDayOfWeek(String entry) throws NumberFormatException {
        String result = DEFAULT_CRON;
        if (entry.contains("-")) {
            entry = CronUtils.formCommaSeparatedEntry(entry);
        }
        if (!entry.contains(",")) {
            return result + CronUtils.convertCronDayToQuartz(Integer.parseInt(entry));
        }
        String splitter = ",";
        for (String number : entry.split(splitter)) {
            result = result + CronUtils.convertCronDayToQuartz(Integer.parseInt(number)) + ",";
        }
        result = result.substring(0, result.length() - 1);
        return result;
    }

    private static String formCommaSeparatedEntry(String entry) throws NumberFormatException {
        String result = DEFAULT_CRON;
        String[] values = entry.split("-");
        if (values.length != 2) {
            throw new NumberFormatException();
        }
        int low = Integer.parseInt(values[0].trim());
        int high = Integer.parseInt(values[1].trim());
        for (int i = low; i <= high; ++i) {
            result = result + i + ",";
        }
        result = result.substring(0, result.length() - 1);
        return result;
    }

    private static int convertCronDayToQuartz(int value) {
        if (value == 7 || value == 0) {
            return 1;
        }
        return value + 1;
    }
}

