/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.resources.achievements.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import so.trophy.core.ObjectMappers;
import so.trophy.types.EventRequestUser;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AchievementsCompleteRequest {
    private final EventRequestUser user;
    private final Map<String, Object> additionalProperties;

    private AchievementsCompleteRequest(EventRequestUser user, Map<String, Object> additionalProperties) {
        this.user = user;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="user")
    public EventRequestUser getUser() {
        return this.user;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AchievementsCompleteRequest && this.equalTo((AchievementsCompleteRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AchievementsCompleteRequest other) {
        return this.user.equals(other.user);
    }

    public int hashCode() {
        return Objects.hash(this.user);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UserStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements UserStage,
    _FinalStage {
        private EventRequestUser user;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AchievementsCompleteRequest other) {
            this.user(other.getUser());
            return this;
        }

        @Override
        @JsonSetter(value="user")
        public _FinalStage user(@NotNull EventRequestUser user) {
            this.user = Objects.requireNonNull(user, "user must not be null");
            return this;
        }

        @Override
        public AchievementsCompleteRequest build() {
            return new AchievementsCompleteRequest(this.user, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AchievementsCompleteRequest build();
    }

    public static interface UserStage {
        public _FinalStage user(@NotNull EventRequestUser var1);

        public Builder from(AchievementsCompleteRequest var1);
    }
}

