/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.resources.metrics.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import so.trophy.core.ObjectMappers;
import so.trophy.types.EventRequestUser;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class MetricsEventRequest {
    private final EventRequestUser user;
    private final double value;
    private final Map<String, Object> additionalProperties;

    private MetricsEventRequest(EventRequestUser user, double value, Map<String, Object> additionalProperties) {
        this.user = user;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="user")
    public EventRequestUser getUser() {
        return this.user;
    }

    @JsonProperty(value="value")
    public double getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MetricsEventRequest && this.equalTo((MetricsEventRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MetricsEventRequest other) {
        return this.user.equals(other.user) && this.value == other.value;
    }

    public int hashCode() {
        return Objects.hash(this.user, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UserStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements UserStage,
    ValueStage,
    _FinalStage {
        private EventRequestUser user;
        private double value;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(MetricsEventRequest other) {
            this.user(other.getUser());
            this.value(other.getValue());
            return this;
        }

        @Override
        @JsonSetter(value="user")
        public ValueStage user(@NotNull EventRequestUser user) {
            this.user = Objects.requireNonNull(user, "user must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(double value) {
            this.value = value;
            return this;
        }

        @Override
        public MetricsEventRequest build() {
            return new MetricsEventRequest(this.user, this.value, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public MetricsEventRequest build();
    }

    public static interface ValueStage {
        public _FinalStage value(double var1);
    }

    public static interface UserStage {
        public ValueStage user(@NotNull EventRequestUser var1);

        public Builder from(MetricsEventRequest var1);
    }
}

