/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.resources.users;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import so.trophy.core.ClientOptions;
import so.trophy.core.ObjectMappers;
import so.trophy.core.RequestOptions;
import so.trophy.core.TrophyApiApiException;
import so.trophy.core.TrophyApiException;
import so.trophy.errors.NotFoundError;
import so.trophy.errors.UnauthorizedError;
import so.trophy.errors.UnprocessableEntityError;
import so.trophy.types.AchievementResponse;
import so.trophy.types.ErrorBody;
import so.trophy.types.MetricResponse;

public class UsersClient {
    protected final ClientOptions clientOptions;

    public UsersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public List<MetricResponse> allmetrics(String userId) {
        return this.allmetrics(userId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<MetricResponse> allmetrics(String userId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("users").addPathSegment(userId).addPathSegments("metrics").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                List list = (List)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), (TypeReference)new TypeReference<List<MetricResponse>>(){});
                return list;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 404: {
                        throw new NotFoundError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 422: {
                        throw new UnprocessableEntityError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                }
                throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new TrophyApiException("Network error executing HTTP request", e);
        }
    }

    public MetricResponse singlemetric(String userId, String key) {
        return this.singlemetric(userId, key, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MetricResponse singlemetric(String userId, String key, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("users").addPathSegment(userId).addPathSegments("metrics").addPathSegment(key).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                MetricResponse metricResponse = (MetricResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), MetricResponse.class);
                return metricResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 404: {
                        throw new NotFoundError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 422: {
                        throw new UnprocessableEntityError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                }
                throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new TrophyApiException("Network error executing HTTP request", e);
        }
    }

    public List<AchievementResponse> allachievements(String userId) {
        return this.allachievements(userId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AchievementResponse> allachievements(String userId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("users").addPathSegment(userId).addPathSegments("achievements").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                List list = (List)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), (TypeReference)new TypeReference<List<AchievementResponse>>(){});
                return list;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 404: {
                        throw new NotFoundError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 422: {
                        throw new UnprocessableEntityError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                }
                throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new TrophyApiException("Network error executing HTTP request", e);
        }
    }
}

