/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import so.trophy.core.ObjectMappers;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EventRequestUser {
    private final String id;
    private final Optional<String> email;
    private final Optional<String> name;
    private final Optional<String> tz;
    private final Map<String, Object> additionalProperties;

    private EventRequestUser(String id, Optional<String> email, Optional<String> name, Optional<String> tz, Map<String, Object> additionalProperties) {
        this.id = id;
        this.email = email;
        this.name = name;
        this.tz = tz;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="email")
    public Optional<String> getEmail() {
        return this.email;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="tz")
    public Optional<String> getTz() {
        return this.tz;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EventRequestUser && this.equalTo((EventRequestUser)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EventRequestUser other) {
        return this.id.equals(other.id) && this.email.equals(other.email) && this.name.equals(other.name) && this.tz.equals(other.tz);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.email, this.name, this.tz);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    _FinalStage {
        private String id;
        private Optional<String> tz = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> email = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(EventRequestUser other) {
            this.id(other.getId());
            this.email(other.getEmail());
            this.name(other.getName());
            this.tz(other.getTz());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage tz(String tz) {
            this.tz = Optional.ofNullable(tz);
            return this;
        }

        @Override
        @JsonSetter(value="tz", nulls=Nulls.SKIP)
        public _FinalStage tz(Optional<String> tz) {
            this.tz = tz;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        @Override
        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public _FinalStage email(Optional<String> email) {
            this.email = email;
            return this;
        }

        @Override
        public EventRequestUser build() {
            return new EventRequestUser(this.id, this.email, this.name, this.tz, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public EventRequestUser build();

        public _FinalStage email(Optional<String> var1);

        public _FinalStage email(String var1);

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage tz(Optional<String> var1);

        public _FinalStage tz(String var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);

        public Builder from(EventRequestUser var1);
    }
}

